require 'vertx-web-common/template_engine'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.templ.rocker.RockerTemplateEngine
module VertxWebTemplRocker
  #  A template engine that uses the Rocker library.
  class RockerTemplateEngine < ::VertxWebCommon::TemplateEngine
    # @private
    # @param j_del [::VertxWebTemplRocker::RockerTemplateEngine] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebTemplRocker::RockerTemplateEngine] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == RockerTemplateEngine
    end
    def @@j_api_type.wrap(obj)
      RockerTemplateEngine.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebTemplRocker::RockerTemplateEngine.java_class
    end
    #  Render the template. Template engines that support partials/fragments should extract the template base path from
    #  the template filename up to the last file separator.
    # 
    #  Some engines support localization, for these engines, there is a predefined key "lang" to specify the language to
    #  be used in the localization, the format should follow the standard locale formats e.g.: "en-gb", "pt-br", "en".
    # @param [Hash{String => Object}] context the routing context
    # @param [String] templateFileName the template file name to use
    # @yield the handler that will be called with a result containing the buffer or a failure.
    # @return [void]
    def render(context=nil,templateFileName=nil)
      if context.class == Hash && templateFileName.class == String && true
        return @j_del.java_method(:render, [Java::IoVertxCoreJson::JsonObject.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_json_object(context),templateFileName,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Buffer) : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling render(#{context},#{templateFileName})"
    end
    #  Create a template engine using a custom extension
    # @param [String] extension 
    # @return [::VertxWebTemplRocker::RockerTemplateEngine] the engine
    def self.create(extension=nil)
      if !block_given? && extension == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebTemplRocker::RockerTemplateEngine.java_method(:create, []).call(),::VertxWebTemplRocker::RockerTemplateEngine)
      elsif extension.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebTemplRocker::RockerTemplateEngine.java_method(:create, [Java::java.lang.String.java_class]).call(extension),::VertxWebTemplRocker::RockerTemplateEngine)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{extension})"
    end
    #  Default template extension
    def self.DEFAULT_TEMPLATE_EXTENSION
      Java::IoVertxExtWebTemplRocker::RockerTemplateEngine.DEFAULT_TEMPLATE_EXTENSION
    end
  end
end
