require 'vertx-web/routing_context'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.StaticHandler
module VertxWeb
  #  A handler for serving static resources from the file system or classpath.
  class StaticHandler
    # @private
    # @param j_del [::VertxWeb::StaticHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::StaticHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == StaticHandler
    end
    def @@j_api_type.wrap(obj)
      StaticHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandler::StaticHandler.java_class
    end
    #  Something has happened, so handle it.
    # @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(event=nil)
      if event.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(event.j_del)
      end
      raise ArgumentError, "Invalid arguments when calling handle(#{event})"
    end
    #  Create a handler, specifying web-root
    # @param [String] root the web-root
    # @return [::VertxWeb::StaticHandler] the handler
    def self.create(root=nil)
      if !block_given? && root == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::StaticHandler.java_method(:create, []).call(),::VertxWeb::StaticHandler)
      elsif root.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::StaticHandler.java_method(:create, [Java::java.lang.String.java_class]).call(root),::VertxWeb::StaticHandler)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{root})"
    end
    #  Enable/Disable access to the root of the filesystem
    # @param [true,false] allowRootFileSystemAccess whether root access is allowed
    # @return [self]
    def set_allow_root_file_system_access(allowRootFileSystemAccess=nil)
      if (allowRootFileSystemAccess.class == TrueClass || allowRootFileSystemAccess.class == FalseClass) && !block_given?
        @j_del.java_method(:setAllowRootFileSystemAccess, [Java::boolean.java_class]).call(allowRootFileSystemAccess)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_allow_root_file_system_access(#{allowRootFileSystemAccess})"
    end
    #  Set the web root
    # @param [String] webRoot the web root
    # @return [self]
    def set_web_root(webRoot=nil)
      if webRoot.class == String && !block_given?
        @j_del.java_method(:setWebRoot, [Java::java.lang.String.java_class]).call(webRoot)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_web_root(#{webRoot})"
    end
    #  Set whether files are read-only and will never change
    # @param [true,false] readOnly whether files are read-only
    # @return [self]
    def set_files_read_only(readOnly=nil)
      if (readOnly.class == TrueClass || readOnly.class == FalseClass) && !block_given?
        @j_del.java_method(:setFilesReadOnly, [Java::boolean.java_class]).call(readOnly)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_files_read_only(#{readOnly})"
    end
    #  Set value for max age in caching headers
    # @param [Fixnum] maxAgeSeconds maximum time for browser to cache, in seconds
    # @return [self]
    def set_max_age_seconds(maxAgeSeconds=nil)
      if maxAgeSeconds.class == Fixnum && !block_given?
        @j_del.java_method(:setMaxAgeSeconds, [Java::long.java_class]).call(maxAgeSeconds)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_max_age_seconds(#{maxAgeSeconds})"
    end
    #  Set whether cache header handling is enabled
    # @param [true,false] enabled true if enabled
    # @return [self]
    def set_caching_enabled(enabled=nil)
      if (enabled.class == TrueClass || enabled.class == FalseClass) && !block_given?
        @j_del.java_method(:setCachingEnabled, [Java::boolean.java_class]).call(enabled)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_caching_enabled(#{enabled})"
    end
    #  Set whether directory listing is enabled
    # @param [true,false] directoryListing true if enabled
    # @return [self]
    def set_directory_listing(directoryListing=nil)
      if (directoryListing.class == TrueClass || directoryListing.class == FalseClass) && !block_given?
        @j_del.java_method(:setDirectoryListing, [Java::boolean.java_class]).call(directoryListing)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_directory_listing(#{directoryListing})"
    end
    #  Set whether hidden files should be served
    # @param [true,false] includeHidden true if hidden files should be served
    # @return [self]
    def set_include_hidden(includeHidden=nil)
      if (includeHidden.class == TrueClass || includeHidden.class == FalseClass) && !block_given?
        @j_del.java_method(:setIncludeHidden, [Java::boolean.java_class]).call(includeHidden)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_include_hidden(#{includeHidden})"
    end
    #  Set the server cache entry timeout when caching is enabled
    # @param [Fixnum] timeout the timeout, in ms
    # @return [self]
    def set_cache_entry_timeout(timeout=nil)
      if timeout.class == Fixnum && !block_given?
        @j_del.java_method(:setCacheEntryTimeout, [Java::long.java_class]).call(timeout)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_cache_entry_timeout(#{timeout})"
    end
    #  Set the index page
    # @param [String] indexPage the index page
    # @return [self]
    def set_index_page(indexPage=nil)
      if indexPage.class == String && !block_given?
        @j_del.java_method(:setIndexPage, [Java::java.lang.String.java_class]).call(indexPage)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_index_page(#{indexPage})"
    end
    #  Set the max cache size, when caching is enabled
    # @param [Fixnum] maxCacheSize the max cache size
    # @return [self]
    def set_max_cache_size(maxCacheSize=nil)
      if maxCacheSize.class == Fixnum && !block_given?
        @j_del.java_method(:setMaxCacheSize, [Java::int.java_class]).call(maxCacheSize)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_max_cache_size(#{maxCacheSize})"
    end
    #  Set the file mapping for http2push and link preload
    # @param [Array<Hash{String => Object}>] http2PushMappings the mapping for http2 push
    # @return [self]
    def set_http2_push_mapping(http2PushMappings=nil)
      if http2PushMappings.class == Array && !block_given?
        @j_del.java_method(:setHttp2PushMapping, [Java::JavaUtil::List.java_class]).call(http2PushMappings.map { |element| Java::IoVertxExtWeb::Http2PushMapping.new(::Vertx::Util::Utils.to_json_object(element)) })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_http2_push_mapping(#{http2PushMappings})"
    end
    #  Skip compression if the media type of the file to send is in the provided <code>mediaTypes</code> set.
    #  <code>Content-Encoding</code> header set to <code>identity</code> for the types present in the <code>mediaTypes</code> set
    # @param [Set<String>] mediaTypes the set of mime types that are already compressed
    # @return [self]
    def skip_compression_for_media_types(mediaTypes=nil)
      if mediaTypes.class == Set && !block_given?
        @j_del.java_method(:skipCompressionForMediaTypes, [Java::JavaUtil::Set.java_class]).call(Java::JavaUtil::LinkedHashSet.new(mediaTypes.map { |element| element }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling skip_compression_for_media_types(#{mediaTypes})"
    end
    #  Skip compression if the suffix of the file to send is in the provided <code>fileSuffixes</code> set.
    #  <code>Content-Encoding</code> header set to <code>identity</code> for the suffixes present in the <code>fileSuffixes</code> set
    # @param [Set<String>] fileSuffixes the set of file suffixes that are already compressed
    # @return [self]
    def skip_compression_for_suffixes(fileSuffixes=nil)
      if fileSuffixes.class == Set && !block_given?
        @j_del.java_method(:skipCompressionForSuffixes, [Java::JavaUtil::Set.java_class]).call(Java::JavaUtil::LinkedHashSet.new(fileSuffixes.map { |element| element }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling skip_compression_for_suffixes(#{fileSuffixes})"
    end
    #  Set whether async filesystem access should always be used
    # @param [true,false] alwaysAsyncFS true for always async FS access
    # @return [self]
    def set_always_async_fs(alwaysAsyncFS=nil)
      if (alwaysAsyncFS.class == TrueClass || alwaysAsyncFS.class == FalseClass) && !block_given?
        @j_del.java_method(:setAlwaysAsyncFS, [Java::boolean.java_class]).call(alwaysAsyncFS)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_always_async_fs(#{alwaysAsyncFS})"
    end
    #  Set whether async/sync filesystem tuning should enabled
    # @param [true,false] enableFSTuning true to enabled FS tuning
    # @return [self]
    def set_enable_fs_tuning(enableFSTuning=nil)
      if (enableFSTuning.class == TrueClass || enableFSTuning.class == FalseClass) && !block_given?
        @j_del.java_method(:setEnableFSTuning, [Java::boolean.java_class]).call(enableFSTuning)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_enable_fs_tuning(#{enableFSTuning})"
    end
    #  Set the max serve time in ns, above which serves are considered slow
    # @param [Fixnum] maxAvgServeTimeNanoSeconds max serve time, in ns
    # @return [self]
    def set_max_avg_serve_time_ns(maxAvgServeTimeNanoSeconds=nil)
      if maxAvgServeTimeNanoSeconds.class == Fixnum && !block_given?
        @j_del.java_method(:setMaxAvgServeTimeNs, [Java::long.java_class]).call(maxAvgServeTimeNanoSeconds)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_max_avg_serve_time_ns(#{maxAvgServeTimeNanoSeconds})"
    end
    #  Set the directory template to be used when directory listing
    # @param [String] directoryTemplate the directory template
    # @return [self]
    def set_directory_template(directoryTemplate=nil)
      if directoryTemplate.class == String && !block_given?
        @j_del.java_method(:setDirectoryTemplate, [Java::java.lang.String.java_class]).call(directoryTemplate)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_directory_template(#{directoryTemplate})"
    end
    #  Set whether range requests (resumable downloads; media streaming) should be enabled.
    # @param [true,false] enableRangeSupport true to enable range support
    # @return [self]
    def set_enable_range_support(enableRangeSupport=nil)
      if (enableRangeSupport.class == TrueClass || enableRangeSupport.class == FalseClass) && !block_given?
        @j_del.java_method(:setEnableRangeSupport, [Java::boolean.java_class]).call(enableRangeSupport)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_enable_range_support(#{enableRangeSupport})"
    end
    #  Set whether vary header should be sent with response.
    # @param [true,false] varyHeader true to sent vary header
    # @return [self]
    def set_send_vary_header(varyHeader=nil)
      if (varyHeader.class == TrueClass || varyHeader.class == FalseClass) && !block_given?
        @j_del.java_method(:setSendVaryHeader, [Java::boolean.java_class]).call(varyHeader)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_send_vary_header(#{varyHeader})"
    end
    #  Set the default content encoding for text related files. This allows overriding the system settings default value.
    # @param [String] contentEncoding the desired content encoding e.g.: "UTF-8"
    # @return [self]
    def set_default_content_encoding(contentEncoding=nil)
      if contentEncoding.class == String && !block_given?
        @j_del.java_method(:setDefaultContentEncoding, [Java::java.lang.String.java_class]).call(contentEncoding)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_default_content_encoding(#{contentEncoding})"
    end
    #  Default value of the web-root, where files are served from
    def self.DEFAULT_WEB_ROOT
      Java::IoVertxExtWebHandler::StaticHandler.DEFAULT_WEB_ROOT
    end
    #  Default value of whether files are read -only and never will be updated
    def self.DEFAULT_FILES_READ_ONLY
      Java::IoVertxExtWebHandler::StaticHandler.DEFAULT_FILES_READ_ONLY
    end
    #  Default max age for cache headers
    def self.DEFAULT_MAX_AGE_SECONDS
      Java::IoVertxExtWebHandler::StaticHandler.DEFAULT_MAX_AGE_SECONDS
    end
    #  Default of whether cache header handling is enabled
    def self.DEFAULT_CACHING_ENABLED
      Java::IoVertxExtWebHandler::StaticHandler.DEFAULT_CACHING_ENABLED
    end
    #  Default of whether directory listing is enabled
    def self.DEFAULT_DIRECTORY_LISTING
      Java::IoVertxExtWebHandler::StaticHandler.DEFAULT_DIRECTORY_LISTING
    end
    #  Default template file to use for directory listing
    def self.DEFAULT_DIRECTORY_TEMPLATE
      Java::IoVertxExtWebHandler::StaticHandler.DEFAULT_DIRECTORY_TEMPLATE
    end
    #  Default of whether hidden files can be served
    def self.DEFAULT_INCLUDE_HIDDEN
      Java::IoVertxExtWebHandler::StaticHandler.DEFAULT_INCLUDE_HIDDEN
    end
    #  Default cache entry timeout, when caching
    def self.DEFAULT_CACHE_ENTRY_TIMEOUT
      Java::IoVertxExtWebHandler::StaticHandler.DEFAULT_CACHE_ENTRY_TIMEOUT
    end
    #  The default index page
    def self.DEFAULT_INDEX_PAGE
      Java::IoVertxExtWebHandler::StaticHandler.DEFAULT_INDEX_PAGE
    end
    #  The default max cache size
    def self.DEFAULT_MAX_CACHE_SIZE
      Java::IoVertxExtWebHandler::StaticHandler.DEFAULT_MAX_CACHE_SIZE
    end
    #  Default of whether async filesystem access should always be used
    def self.DEFAULT_ALWAYS_ASYNC_FS
      Java::IoVertxExtWebHandler::StaticHandler.DEFAULT_ALWAYS_ASYNC_FS
    end
    #  Default of whether fs async/sync tuning should be used
    def self.DEFAULT_ENABLE_FS_TUNING
      Java::IoVertxExtWebHandler::StaticHandler.DEFAULT_ENABLE_FS_TUNING
    end
    #  Default max avg serve time, in ns, over which serving will be considered slow
    def self.DEFAULT_MAX_AVG_SERVE_TIME_NS
      Java::IoVertxExtWebHandler::StaticHandler.DEFAULT_MAX_AVG_SERVE_TIME_NS
    end
    #  Default of whether Range request handling support should be used
    def self.DEFAULT_RANGE_SUPPORT
      Java::IoVertxExtWebHandler::StaticHandler.DEFAULT_RANGE_SUPPORT
    end
    #  Default of whether access to the root of the file system should be allowed or just allow from the current working
    #  directory.
    def self.DEFAULT_ROOT_FILESYSTEM_ACCESS
      Java::IoVertxExtWebHandler::StaticHandler.DEFAULT_ROOT_FILESYSTEM_ACCESS
    end
    #  Default of whether vary header should be sent.
    def self.DEFAULT_SEND_VARY_HEADER
      Java::IoVertxExtWebHandler::StaticHandler.DEFAULT_SEND_VARY_HEADER
    end
  end
end
