require 'vertx-amqp-client/amqp_message'
require 'vertx/vertx'
require 'vertx-amqp-client/amqp_sender'
require 'vertx-amqp-client/amqp_connection'
require 'vertx-amqp-client/amqp_receiver'
require 'vertx/util/utils.rb'
# Generated from io.vertx.amqp.AmqpClient
module VertxAmqpClient
  #  AMQP Client entry point.
  #  Use this interface to create an instance of {::VertxAmqpClient::AmqpClient} and connect to a broker and server.
  class AmqpClient
    # @private
    # @param j_del [::VertxAmqpClient::AmqpClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAmqpClient::AmqpClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == AmqpClient
    end
    def @@j_api_type.wrap(obj)
      AmqpClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxAmqp::AmqpClient.java_class
    end
    #  Creates a new instance of {::VertxAmqpClient::AmqpClient} with the given Vert.x instance and the given options.
    # @overload create(options)
    #   @param [Hash{String => Object}] options the AMQP client options, may be <code>null</code> falling back to the default configuration
    # @overload create(vertx,options)
    #   @param [::Vertx::Vertx] vertx the vert.x instance, must not be <code>null</code>
    #   @param [Hash{String => Object}] options the AMQP options, may be @{code null} falling back to the default configuration
    # @return [::VertxAmqpClient::AmqpClient] the AMQP client instance
    def self.create(param_1=nil,param_2=nil)
      if param_1.class == Hash && !block_given? && param_2 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxAmqp::AmqpClient.java_method(:create, [Java::IoVertxAmqp::AmqpClientOptions.java_class]).call(Java::IoVertxAmqp::AmqpClientOptions.new(::Vertx::Util::Utils.to_json_object(param_1))),::VertxAmqpClient::AmqpClient)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxAmqp::AmqpClient.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxAmqp::AmqpClientOptions.java_class]).call(param_1.j_del,Java::IoVertxAmqp::AmqpClientOptions.new(::Vertx::Util::Utils.to_json_object(param_2))),::VertxAmqpClient::AmqpClient)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{param_1},#{param_2})"
    end
    #  Connects to the AMQP broker or router. The location is specified in the {Hash{String => Object}} as well as the
    #  potential credential required.
    # @yield handler that will process the result, giving either the connection or failure cause. Must not be <code>null</code>.
    # @return [self]
    def connect
      if true
        @j_del.java_method(:connect, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpConnection) : nil) } unless !block_given?))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling connect()"
    end
    #  Closes the client.
    #  The client must always be closed once not needed anymore.
    # @yield the close handler notified when the operation completes. It can be <code>null</code>.
    # @return [void]
    def close
      if true
        return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
    #  Creates a receiver used to consumer messages from the given address.  This method avoids having to connect
    #  explicitly. You can retrieve the connection using {::VertxAmqpClient::AmqpReceiver#connection}.
    # @overload createReceiver(address,completionHandler)
    #   @param [String] address The source address to attach the consumer to, must not be <code>null</code>
    #   @yield the handler called with the receiver. The receiver has been opened.
    # @overload createReceiver(address,messageHandler,completionHandler)
    #   @param [String] address The source address to attach the consumer to, must not be <code>null</code>
    #   @param [Proc] messageHandler The message handler, must not be <code>null</code>
    #   @yield the handler called with the receiver that has been opened. Note that the <code>messageHandler</code> can be called before the <code>completionHandler</code> if messages are awaiting delivery.
    # @overload createReceiver(address,receiverOptions,messageHandler,completionHandler)
    #   @param [String] address The source address to attach the consumer to.
    #   @param [Hash{String => Object}] receiverOptions The options for this receiver.
    #   @param [Proc] messageHandler The message handler, must not be <code>null</code>
    #   @yield The handler called with the receiver, once opened. Note that the <code>messageHandler</code> can be called before the <code>completionHandler</code> if messages are awaiting delivery.
    # @return [self]
    def create_receiver(param_1=nil,param_2=nil,param_3=nil)
      if param_1.class == String && true && param_2 == nil && param_3 == nil
        @j_del.java_method(:createReceiver, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpReceiver) : nil) } unless !block_given?))
        return self
      elsif param_1.class == String && param_2.class == Proc && true && param_3 == nil
        @j_del.java_method(:createReceiver, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,(Proc.new { |event| param_2.call(::Vertx::Util::Utils.safe_create(event,::VertxAmqpClient::AmqpMessage)) unless param_2 == nil }),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpReceiver) : nil) } unless !block_given?))
        return self
      elsif param_1.class == String && param_2.class == Hash && param_3.class == Proc && true
        @j_del.java_method(:createReceiver, [Java::java.lang.String.java_class,Java::IoVertxAmqp::AmqpReceiverOptions.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,Java::IoVertxAmqp::AmqpReceiverOptions.new(::Vertx::Util::Utils.to_json_object(param_2)),(Proc.new { |event| param_3.call(::Vertx::Util::Utils.safe_create(event,::VertxAmqpClient::AmqpMessage)) unless param_3 == nil }),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpReceiver) : nil) } unless !block_given?))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling create_receiver(#{param_1},#{param_2},#{param_3})"
    end
    #  Creates a sender used to send messages to the given address. The address must be set.
    # @param [String] address The target address to attach to, must not be <code>null</code>
    # @param [Hash{String => Object}] options The options for this sender.
    # @yield The handler called with the sender, once opened
    # @return [self]
    def create_sender(address=nil,options=nil)
      if address.class == String && true && options == nil
        @j_del.java_method(:createSender, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(address,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpSender) : nil) } unless !block_given?))
        return self
      elsif address.class == String && options.class == Hash && true
        @j_del.java_method(:createSender, [Java::java.lang.String.java_class,Java::IoVertxAmqp::AmqpSenderOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(address,Java::IoVertxAmqp::AmqpSenderOptions.new(::Vertx::Util::Utils.to_json_object(options)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpSender) : nil) } unless !block_given?))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling create_sender(#{address},#{options})"
    end
  end
end
