require 'vertx/vertx'
require 'vertx-auth-common/auth_provider'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.htdigest.HtdigestAuth
module VertxAuthHtdigest
  #  An extension of AuthProvider which is using .htdigest file as store
  class HtdigestAuth < ::VertxAuthCommon::AuthProvider
    # @private
    # @param j_del [::VertxAuthHtdigest::HtdigestAuth] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthHtdigest::HtdigestAuth] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == HtdigestAuth
    end
    def @@j_api_type.wrap(obj)
      HtdigestAuth.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthHtdigest::HtdigestAuth.java_class
    end
    #  Authenticate a user.
    #  <p>
    #  The first argument is a JSON object containing information for authenticating the user. What this actually contains
    #  depends on the specific implementation. In the case of a simple username/password based
    #  authentication it is likely to contain a JSON object with the following structure:
    #  <pre>
    #    {
    #      "username": "tim",
    #      "password": "mypassword"
    #    }
    #  </pre>
    #  For other types of authentication it contain different information - for example a JWT token or OAuth bearer token.
    #  <p>
    #  If the user is successfully authenticated a  object is passed to the handler in an {AsyncResult}.
    #  The user object can then be used for authorisation.
    # @param [Hash{String => Object}] authInfo The auth information
    # @yield The result handler
    # @return [void]
    def authenticate(authInfo=nil)
      if authInfo.class == Hash && true
        return @j_del.java_method(:authenticate, [Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_json_object(authInfo),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthCommon::User) : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling authenticate(#{authInfo})"
    end
    #  Creates an instance of HtdigestAuth by using the given htfile file.
    # @param [::Vertx::Vertx] vertx 
    # @param [String] htfile the existing htfile.
    # @return [::VertxAuthHtdigest::HtdigestAuth] the created instance of {::VertxAuthHtdigest::HtdigestAuth}s
    def self.create(vertx=nil,htfile=nil)
      if vertx.class.method_defined?(:j_del) && !block_given? && htfile == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthHtdigest::HtdigestAuth.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(vertx.j_del),::VertxAuthHtdigest::HtdigestAuth)
      elsif vertx.class.method_defined?(:j_del) && htfile.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthHtdigest::HtdigestAuth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(vertx.j_del,htfile),::VertxAuthHtdigest::HtdigestAuth)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{vertx},#{htfile})"
    end
    #  Return the currently used realm
    # @return [String] the realm
    def realm
      if !block_given?
        return @j_del.java_method(:realm, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling realm()"
    end
    #  The property name to be used to set the name of the collection inside the config
    def self.HTDIGEST_FILE
      Java::IoVertxExtAuthHtdigest::HtdigestAuth.HTDIGEST_FILE
    end
  end
end
