require 'vertx/vertx'
require 'vertx-auth-common/auth_provider'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.htpasswd.HtpasswdAuth
module VertxAuthHtpasswd
  #  An extension of AuthProvider which is using htpasswd file as store
  class HtpasswdAuth < ::VertxAuthCommon::AuthProvider
    # @private
    # @param j_del [::VertxAuthHtpasswd::HtpasswdAuth] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthHtpasswd::HtpasswdAuth] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == HtpasswdAuth
    end
    def @@j_api_type.wrap(obj)
      HtpasswdAuth.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthHtpasswd::HtpasswdAuth.java_class
    end
    #  Authenticate a user.
    #  <p>
    #  The first argument is a JSON object containing information for authenticating the user. What this actually contains
    #  depends on the specific implementation. In the case of a simple username/password based
    #  authentication it is likely to contain a JSON object with the following structure:
    #  <pre>
    #    {
    #      "username": "tim",
    #      "password": "mypassword"
    #    }
    #  </pre>
    #  For other types of authentication it contain different information - for example a JWT token or OAuth bearer token.
    #  <p>
    #  If the user is successfully authenticated a  object is passed to the handler in an {AsyncResult}.
    #  The user object can then be used for authorisation.
    # @param [Hash{String => Object}] authInfo The auth information
    # @yield The result handler
    # @return [void]
    def authenticate(authInfo=nil)
      if authInfo.class == Hash && true
        return @j_del.java_method(:authenticate, [Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_json_object(authInfo),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthCommon::User) : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling authenticate(#{authInfo})"
    end
    # @param [::Vertx::Vertx] vertx 
    # @param [Hash{String => Object}] htpasswdAuthOptions 
    # @return [::VertxAuthHtpasswd::HtpasswdAuth]
    def self.create(vertx=nil,htpasswdAuthOptions=nil)
      if vertx.class.method_defined?(:j_del) && !block_given? && htpasswdAuthOptions == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthHtpasswd::HtpasswdAuth.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(vertx.j_del),::VertxAuthHtpasswd::HtpasswdAuth)
      elsif vertx.class.method_defined?(:j_del) && htpasswdAuthOptions.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthHtpasswd::HtpasswdAuth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtAuthHtpasswd::HtpasswdAuthOptions.java_class]).call(vertx.j_del,Java::IoVertxExtAuthHtpasswd::HtpasswdAuthOptions.new(::Vertx::Util::Utils.to_json_object(htpasswdAuthOptions))),::VertxAuthHtpasswd::HtpasswdAuth)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{vertx},#{htpasswdAuthOptions})"
    end
  end
end
