require 'vertx-auth-oauth2/open_id_connect_auth'
require 'vertx/vertx'
require 'vertx-auth-oauth2/o_auth2_auth'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.oauth2.providers.GoogleAuth
module VertxAuthOauth2
  #  Simplified factory to create an {::VertxAuthOauth2::OAuth2Auth} for Google.
  class GoogleAuth < ::VertxAuthOauth2::OpenIDConnectAuth
    # @private
    # @param j_del [::VertxAuthOauth2::GoogleAuth] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthOauth2::GoogleAuth] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == GoogleAuth
    end
    def @@j_api_type.wrap(obj)
      GoogleAuth.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthOauth2Providers::GoogleAuth.java_class
    end
    #  Create a OAuth2Auth provider for Google
    # @overload create(vertx,serviceAccountJson)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [Hash{String => Object}] serviceAccountJson the configuration json file from your Google API page
    # @overload create(vertx,clientId,clientSecret)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] clientId the client id given to you by Google
    #   @param [String] clientSecret the client secret given to you by Google
    # @overload create(vertx,serviceAccountJson,httpClientOptions)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [Hash{String => Object}] serviceAccountJson the configuration json file from your Google API page
    #   @param [Hash{String => Object}] httpClientOptions custom http client options
    # @overload create(vertx,clientId,clientSecret,httpClientOptions)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] clientId the client id given to you by Google
    #   @param [String] clientSecret the client secret given to you by Google
    #   @param [Hash{String => Object}] httpClientOptions custom http client options
    # @return [::VertxAuthOauth2::OAuth2Auth]
    def self.create(param_1=nil,param_2=nil,param_3=nil,param_4=nil)
      if param_1.class.method_defined?(:j_del) && param_2.class == Hash && !block_given? && param_3 == nil && param_4 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthOauth2Providers::GoogleAuth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(param_1.j_del,::Vertx::Util::Utils.to_json_object(param_2)),::VertxAuthOauth2::OAuth2Auth)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == String && param_3.class == String && !block_given? && param_4 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthOauth2Providers::GoogleAuth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(param_1.j_del,param_2,param_3),::VertxAuthOauth2::OAuth2Auth)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == Hash && param_3.class == Hash && !block_given? && param_4 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthOauth2Providers::GoogleAuth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreHttp::HttpClientOptions.java_class]).call(param_1.j_del,::Vertx::Util::Utils.to_json_object(param_2),Java::IoVertxCoreHttp::HttpClientOptions.new(::Vertx::Util::Utils.to_json_object(param_3))),::VertxAuthOauth2::OAuth2Auth)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == String && param_3.class == String && param_4.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthOauth2Providers::GoogleAuth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreHttp::HttpClientOptions.java_class]).call(param_1.j_del,param_2,param_3,Java::IoVertxCoreHttp::HttpClientOptions.new(::Vertx::Util::Utils.to_json_object(param_4))),::VertxAuthOauth2::OAuth2Auth)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{param_1},#{param_2},#{param_3},#{param_4})"
    end
    #  Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the default site in the
    #  configuration options and attempt to load the well known descriptor. If a site is provided (for example when
    #  running on a custom instance) that site will be used to do the lookup.
    #  <p>
    #  If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
    #  into the OAuth provider so tokens can be decoded.
    # @param [::Vertx::Vertx] vertx the vertx instance
    # @param [Hash{String => Object}] config the initial config
    # @yield the instantiated Oauth2 provider instance handler
    # @return [void]
    def self.discover(vertx=nil,config=nil)
      if vertx.class.method_defined?(:j_del) && config.class == Hash && true
        return Java::IoVertxExtAuthOauth2Providers::GoogleAuth.java_method(:discover, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtAuthOauth2::OAuth2ClientOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(vertx.j_del,Java::IoVertxExtAuthOauth2::OAuth2ClientOptions.new(::Vertx::Util::Utils.to_json_object(config)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::OAuth2Auth) : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling discover(#{vertx},#{config})"
    end
  end
end
