require 'vertx/util/utils.rb'
# Generated from io.vertx.cassandra.Mapper
module VertxCassandra
  #  It is like , but adapted for Vert.x.
  class Mapper
    # @private
    # @param j_del [::VertxCassandra::Mapper] the java delegate
    def initialize(j_del, j_arg_T=nil)
      @j_del = j_del
      @j_arg_T = j_arg_T != nil ? j_arg_T : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::VertxCassandra::Mapper] the underlying java delegate
    def j_del
      @j_del
    end
    #  Asynchronous save method.
    # @param [Object] entity object to be stored in database
    # @yield result handler
    # @return [void]
    def save(entity=nil)
      if @j_arg_T.accept?(entity) && true
        return @j_del.java_method(:save, [Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(@j_arg_T.unwrap(entity),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling save(#{entity})"
    end
    #  Asynchronous delete method based on the column values of the primary key.
    # @param [Array<Object>] primaryKey primary key used to find row to delete
    # @yield result handler
    # @return [void]
    def delete(primaryKey=nil)
      if primaryKey.class == Array && true
        return @j_del.java_method(:delete, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(primaryKey.map { |element| ::Vertx::Util::Utils.to_object(element) },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling delete(#{primaryKey})"
    end
    #  Asynchronous get method based on the column values of the primary key.
    # @param [Array<Object>] primaryKey primary key used to retrieve row
    # @yield result handler
    # @return [void]
    def get(primaryKey=nil)
      if primaryKey.class == Array && true
        return @j_del.java_method(:get, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(primaryKey.map { |element| ::Vertx::Util::Utils.to_object(element) },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? @j_arg_T.wrap(ar.result) : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling get(#{primaryKey})"
    end
  end
end
