require 'vertx/buffer'
require 'vertx/multi_map'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.mail.MailAttachment
module VertxMail
  #  Represent a mail attachment that can be used in a MailMessage.
  class MailAttachment
    # @private
    # @param j_del [::VertxMail::MailAttachment] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxMail::MailAttachment] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MailAttachment
    end
    def @@j_api_type.wrap(obj)
      MailAttachment.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtMail::MailAttachment.java_class
    end
    #  create a copy of a MailAttachment object
    # @overload create()
    # @overload create(json)
    #   @param [Hash{String => Object}] json object to be copied
    # @overload create(other)
    #   @param [::VertxMail::MailAttachment] other object to be copied
    # @return [::VertxMail::MailAttachment]
    def self.create(param_1=nil)
      if !block_given? && param_1 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtMail::MailAttachment.java_method(:create, []).call(),::VertxMail::MailAttachment)
      elsif param_1.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtMail::MailAttachment.java_method(:create, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(param_1)),::VertxMail::MailAttachment)
      elsif param_1.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtMail::MailAttachment.java_method(:create, [Java::IoVertxExtMail::MailAttachment.java_class]).call(param_1.j_del),::VertxMail::MailAttachment)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{param_1})"
    end
    #  get the data
    # @return [::Vertx::Buffer] the data
    def get_data
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getData, []).call(),::Vertx::Buffer)
      end
      raise ArgumentError, "Invalid arguments when calling get_data()"
    end
    #  set the data
    # @param [::Vertx::Buffer] data Buffer of bytes to be used at attachment
    # @return [self]
    def set_data(data=nil)
      if data.class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:setData, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(data.j_del)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_data(#{data})"
    end
    #  get the name
    # @return [String] the name
    def get_name
      if !block_given?
        return @j_del.java_method(:getName, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_name()"
    end
    #  set the name
    # @param [String] name name of the attachment file
    # @return [self]
    def set_name(name=nil)
      if name.class == String && !block_given?
        @j_del.java_method(:setName, [Java::java.lang.String.java_class]).call(name)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_name(#{name})"
    end
    #  get the Content-Type
    # @return [String] the contentType
    def get_content_type
      if !block_given?
        return @j_del.java_method(:getContentType, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_content_type()"
    end
    #  set the Content-Type
    # @param [String] contentType the contentType
    # @return [self]
    def set_content_type(contentType=nil)
      if contentType.class == String && !block_given?
        @j_del.java_method(:setContentType, [Java::java.lang.String.java_class]).call(contentType)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_content_type(#{contentType})"
    end
    #  get the disposition field
    # @return [String] the disposition
    def get_disposition
      if !block_given?
        return @j_del.java_method(:getDisposition, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_disposition()"
    end
    #  set the disposition field to be used in the attachment
    # @param [String] disposition the disposition
    # @return [self]
    def set_disposition(disposition=nil)
      if disposition.class == String && !block_given?
        @j_del.java_method(:setDisposition, [Java::java.lang.String.java_class]).call(disposition)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_disposition(#{disposition})"
    end
    #  get the description field
    # @return [String] the description
    def get_description
      if !block_given?
        return @j_del.java_method(:getDescription, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_description()"
    end
    #  set the description field to be used in the attachment
    # @param [String] description the description
    # @return [self]
    def set_description(description=nil)
      if description.class == String && !block_given?
        @j_del.java_method(:setDescription, [Java::java.lang.String.java_class]).call(description)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_description(#{description})"
    end
    #  get the Content-ID field
    # @return [String] the content id
    def get_content_id
      if !block_given?
        return @j_del.java_method(:getContentId, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_content_id()"
    end
    #  set the Content-ID field to be used in the attachment
    # @param [String] contentId the content id
    # @return [self]
    def set_content_id(contentId=nil)
      if contentId.class == String && !block_given?
        @j_del.java_method(:setContentId, [Java::java.lang.String.java_class]).call(contentId)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_content_id(#{contentId})"
    end
    #  Add an header to this attachment.
    # @param [String] key the header key
    # @param [String] value the header value
    # @return [self]
    def add_header(key=nil,value=nil)
      if key.class == String && value.class == String && !block_given?
        @j_del.java_method(:addHeader, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(key,value)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_header(#{key},#{value})"
    end
    #  Get the headers to be added for this attachment.
    # @return [::Vertx::MultiMap] the headers
    def get_headers
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getHeaders, []).call(),::Vertx::MultiMap)
      end
      raise ArgumentError, "Invalid arguments when calling get_headers()"
    end
    #  Set the headers to be added for this attachment.
    # @param [::Vertx::MultiMap] headers the headers to be added
    # @return [self]
    def set_headers(headers=nil)
      if headers.class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:setHeaders, [Java::IoVertxCore::MultiMap.java_class]).call(headers.j_del)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_headers(#{headers})"
    end
    #  convert this object to JSON representation
    # @return [Hash{String => Object}] the JSON object
    def to_json
      if !block_given?
        return @j_del.java_method(:toJson, []).call() != nil ? JSON.parse(@j_del.java_method(:toJson, []).call().encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling to_json()"
    end
  end
end
