require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.shell.term.Tty
module VertxShell
  #  Provide interactions with the Shell TTY.
  class Tty
    # @private
    # @param j_del [::VertxShell::Tty] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxShell::Tty] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Tty
    end
    def @@j_api_type.wrap(obj)
      Tty.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtShellTerm::Tty.java_class
    end
    # @return [String] the declared tty type, for instance , , etc... it can be null when the tty does not have declared its type.
    def type
      if !block_given?
        return @j_del.java_method(:type, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling type()"
    end
    # @return [Fixnum] the current width, i.e the number of rows or  if unknown
    def width
      if !block_given?
        return @j_del.java_method(:width, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling width()"
    end
    # @return [Fixnum] the current height, i.e the number of columns or  if unknown
    def height
      if !block_given?
        return @j_del.java_method(:height, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling height()"
    end
    #  Set a stream handler on the standard input to read the data.
    # @yield the standard input
    # @return [self]
    def stdin_handler
      if true
        @j_del.java_method(:stdinHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event) unless !block_given? }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling stdin_handler()"
    end
    #  Write data to the standard output.
    # @param [String] data the data to write
    # @return [self]
    def write(data=nil)
      if data.class == String && !block_given?
        @j_del.java_method(:write, [Java::java.lang.String.java_class]).call(data)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling write(#{data})"
    end
    #  Set a resize handler, the handler is called when the tty size changes.
    # @yield the resize handler
    # @return [self]
    def resizehandler
      if true
        @j_del.java_method(:resizehandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield unless !block_given? })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling resizehandler()"
    end
  end
end
