require 'vertx-web-common/template_engine'
require 'vertx/vertx'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.templ.mvel.MVELTemplateEngine
module VertxWebTemplMvel
  #  A template engine that uses the Handlebars library.
  class MVELTemplateEngine < ::VertxWebCommon::TemplateEngine
    # @private
    # @param j_del [::VertxWebTemplMvel::MVELTemplateEngine] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebTemplMvel::MVELTemplateEngine] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MVELTemplateEngine
    end
    def @@j_api_type.wrap(obj)
      MVELTemplateEngine.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebTemplMvel::MVELTemplateEngine.java_class
    end
    #  Render the template. Template engines that support partials/fragments should extract the template base path from
    #  the template filename up to the last file separator.
    # 
    #  Some engines support localization, for these engines, there is a predefined key "lang" to specify the language to
    #  be used in the localization, the format should follow the standard locale formats e.g.: "en-gb", "pt-br", "en".
    # @param [Hash{String => Object}] context the routing context
    # @param [String] templateFileName the template file name to use
    # @yield the handler that will be called with a result containing the buffer or a failure.
    # @return [void]
    def render(context=nil,templateFileName=nil)
      if context.class == Hash && templateFileName.class == String && true
        return @j_del.java_method(:render, [Java::IoVertxCoreJson::JsonObject.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_json_object(context),templateFileName,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Buffer) : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling render(#{context},#{templateFileName})"
    end
    #  Create a template engine using defaults
    # @param [::Vertx::Vertx] vertx 
    # @param [String] extension 
    # @return [::VertxWebTemplMvel::MVELTemplateEngine] the engine
    def self.create(vertx=nil,extension=nil)
      if vertx.class.method_defined?(:j_del) && !block_given? && extension == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebTemplMvel::MVELTemplateEngine.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(vertx.j_del),::VertxWebTemplMvel::MVELTemplateEngine)
      elsif vertx.class.method_defined?(:j_del) && extension.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebTemplMvel::MVELTemplateEngine.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(vertx.j_del,extension),::VertxWebTemplMvel::MVELTemplateEngine)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{vertx},#{extension})"
    end
    #  Default template extension
    def self.DEFAULT_TEMPLATE_EXTENSION
      Java::IoVertxExtWebTemplMvel::MVELTemplateEngine.DEFAULT_TEMPLATE_EXTENSION
    end
  end
end
