require 'vertx-web/auth_handler'
require 'vertx-auth-common/user'
require 'vertx-web/routing_context'
require 'vertx-auth-common/auth_provider'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.BasicAuthHandler
module VertxWeb
  #  An auth handler that provides HTTP Basic Authentication support.
  class BasicAuthHandler
    include ::VertxWeb::AuthHandler
    # @private
    # @param j_del [::VertxWeb::BasicAuthHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::BasicAuthHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == BasicAuthHandler
    end
    def @@j_api_type.wrap(obj)
      BasicAuthHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandler::BasicAuthHandler.java_class
    end
    #  Something has happened, so handle it.
    # @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(event=nil)
      if event.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(event.j_del)
      end
      raise ArgumentError, "Invalid arguments when calling handle(#{event})"
    end
    #  Add a required authority for this auth handler
    # @param [String] authority the authority
    # @return [self]
    def add_authority(authority=nil)
      if authority.class == String && !block_given?
        @j_del.java_method(:addAuthority, [Java::java.lang.String.java_class]).call(authority)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_authority(#{authority})"
    end
    #  Add a set of required authorities for this auth handler
    # @param [Set<String>] authorities the set of authorities
    # @return [self]
    def add_authorities(authorities=nil)
      if authorities.class == Set && !block_given?
        @j_del.java_method(:addAuthorities, [Java::JavaUtil::Set.java_class]).call(Java::JavaUtil::LinkedHashSet.new(authorities.map { |element| element }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_authorities(#{authorities})"
    end
    #  Parses the credentials from the request into a JsonObject. The implementation should
    #  be able to extract the required info for the auth provider in the format the provider
    #  expects.
    # @param [::VertxWeb::RoutingContext] context the routing context
    # @yield the handler to be called once the information is available.
    # @return [void]
    def parse_credentials(context=nil)
      if context.class.method_defined?(:j_del) && true
        return @j_del.java_method(:parseCredentials, [Java::IoVertxExtWeb::RoutingContext.java_class,Java::IoVertxCore::Handler.java_class]).call(context.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling parse_credentials(#{context})"
    end
    #  Authorizes the given user against all added authorities.
    # @param [::VertxAuthCommon::User] user a user.
    # @yield the handler for the result.
    # @return [void]
    def authorize(user=nil)
      if user.class.method_defined?(:j_del) && true
        return @j_del.java_method(:authorize, [Java::IoVertxExtAuth::User.java_class,Java::IoVertxCore::Handler.java_class]).call(user.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling authorize(#{user})"
    end
    #  Create a basic auth handler, specifying realm
    # @param [::VertxAuthCommon::AuthProvider] authProvider the auth service to use
    # @param [String] realm the realm to use
    # @return [::VertxWeb::AuthHandler] the auth handler
    def self.create(authProvider=nil,realm=nil)
      if authProvider.class.method_defined?(:j_del) && !block_given? && realm == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::BasicAuthHandler.java_method(:create, [Java::IoVertxExtAuth::AuthProvider.java_class]).call(authProvider.j_del),::VertxWeb::AuthHandlerImpl)
      elsif authProvider.class.method_defined?(:j_del) && realm.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::BasicAuthHandler.java_method(:create, [Java::IoVertxExtAuth::AuthProvider.java_class,Java::java.lang.String.java_class]).call(authProvider.j_del,realm),::VertxWeb::AuthHandlerImpl)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{authProvider},#{realm})"
    end
    #  The default realm to use
    def self.DEFAULT_REALM
      Java::IoVertxExtWebHandler::BasicAuthHandler.DEFAULT_REALM
    end
  end
end
