require 'vertx-web/routing_context'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.MethodOverrideHandler
module VertxWeb
  class MethodOverrideHandler
    # @private
    # @param j_del [::VertxWeb::MethodOverrideHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::MethodOverrideHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MethodOverrideHandler
    end
    def @@j_api_type.wrap(obj)
      MethodOverrideHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandler::MethodOverrideHandler.java_class
    end
    #  Something has happened, so handle it.
    # @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(event=nil)
      if event.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(event.j_del)
      end
      raise ArgumentError, "Invalid arguments when calling handle(#{event})"
    end
    #  Create a X-HTTP-METHOD-OVERRIDE handler
    # @param [true,false] useSafeDowngrade if set to true, the method overriding will not happen if the overridden method is more idempotent or safer than the overriding method.
    # @return [::VertxWeb::MethodOverrideHandler] the X-HTTP-METHOD-OVERRIDE handler
    def self.create(useSafeDowngrade=nil)
      if !block_given? && useSafeDowngrade == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::MethodOverrideHandler.java_method(:create, []).call(),::VertxWeb::MethodOverrideHandler)
      elsif (useSafeDowngrade.class == TrueClass || useSafeDowngrade.class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::MethodOverrideHandler.java_method(:create, [Java::boolean.java_class]).call(useSafeDowngrade),::VertxWeb::MethodOverrideHandler)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{useSafeDowngrade})"
    end
  end
end
