require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.CompositeFuture
module Vertx
  #  The composite future wraps a list of {::Vertx::Futurefutures}, it is useful when several futures
  #  needs to be coordinated.
  #  The handlers set for the coordinated futures are overridden by the handler of the composite future.
  class CompositeFuture < ::Vertx::Future
    # @private
    # @param j_del [::Vertx::CompositeFuture] the java delegate
    def initialize(j_del)
      super(j_del, ::Vertx::CompositeFuture.j_api_type)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::CompositeFuture] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == CompositeFuture
    end
    def @@j_api_type.wrap(obj)
      CompositeFuture.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCore::CompositeFuture.java_class
    end
    #  Returns true if a wrapped future is completed
    # @param [Fixnum] index the wrapped future index
    # @return [true,false]
    def complete?(index=nil)
      if !block_given? && index == nil
        return @j_del.java_method(:isComplete, []).call()
      elsif index.class == Fixnum && !block_given?
        return @j_del.java_method(:isComplete, [Java::int.java_class]).call(index)
      end
      raise ArgumentError, "Invalid arguments when calling complete?(#{index})"
    end
    # @return [Proc] the handler for the result
    def get_handler
      if !block_given?
        return ::Vertx::Util::Utils.to_async_result_handler_proc(@j_del.java_method(:getHandler, []).call()) { |val| val.j_del }
      end
      raise ArgumentError, "Invalid arguments when calling get_handler()"
    end
    #  The result of the operation. This will be null if the operation failed.
    # @return [::Vertx::CompositeFuture] the result or null if the operation failed.
    def result
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:result, []).call(),::Vertx::CompositeFuture)
      end
      raise ArgumentError, "Invalid arguments when calling result()"
    end
    #  Returns a cause of a wrapped future
    # @param [Fixnum] index the wrapped future index
    # @return [Exception]
    def cause(index=nil)
      if !block_given? && index == nil
        return ::Vertx::Util::Utils.from_throwable(@j_del.java_method(:cause, []).call())
      elsif index.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.from_throwable(@j_del.java_method(:cause, [Java::int.java_class]).call(index))
      end
      raise ArgumentError, "Invalid arguments when calling cause(#{index})"
    end
    #  Returns true if a wrapped future is succeeded
    # @param [Fixnum] index the wrapped future index
    # @return [true,false]
    def succeeded?(index=nil)
      if !block_given? && index == nil
        return @j_del.java_method(:succeeded, []).call()
      elsif index.class == Fixnum && !block_given?
        return @j_del.java_method(:succeeded, [Java::int.java_class]).call(index)
      end
      raise ArgumentError, "Invalid arguments when calling succeeded?(#{index})"
    end
    #  Returns true if a wrapped future is failed
    # @param [Fixnum] index the wrapped future index
    # @return [true,false]
    def failed?(index=nil)
      if !block_given? && index == nil
        return @j_del.java_method(:failed, []).call()
      elsif index.class == Fixnum && !block_given?
        return @j_del.java_method(:failed, [Java::int.java_class]).call(index)
      end
      raise ArgumentError, "Invalid arguments when calling failed?(#{index})"
    end
    #  Compose this future with a <code>mapper</code> function.<p>
    # 
    #  When this future (the one on which <code>compose</code> is called) succeeds, the <code>mapper</code> will be called with
    #  the completed value and this mapper returns another future object. This returned future completion will complete
    #  the future returned by this method call.<p>
    # 
    #  If the <code>mapper</code> throws an exception, the returned future will be failed with this exception.<p>
    # 
    #  When this future fails, the failure will be propagated to the returned future and the <code>mapper</code>
    #  will not be called.
    # @yield the mapper function
    # @return [::Vertx::Future] the composed future
    def compose(mapper=nil)
      if block_given? && mapper == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:compose, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::CompositeFuture)).j_del unless !block_given? })),::Vertx::Future, nil)
      end
      raise ArgumentError, "Invalid arguments when calling compose(#{mapper})"
    end
    #  Map the result of a future to a specific <code>value</code>.<p>
    # 
    #  When this future succeeds, this <code>value</code> will complete the future returned by this method call.<p>
    # 
    #  When this future fails, the failure will be propagated to the returned future.
    # @overload map(mapper)
    #   @yield the mapper function
    # @overload map(value)
    #   @param [Object] value the value that eventually completes the mapped future
    # @return [::Vertx::Future] the mapped future
    def map(param_1=nil)
      if block_given? && param_1 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:map, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| ::Vertx::Util::Utils.to_object(yield(::Vertx::Util::Utils.safe_create(event,::Vertx::CompositeFuture))) unless !block_given? })),::Vertx::Future, nil)
      elsif ::Vertx::Util::unknown_type.accept?(param_1) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:map, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(param_1)),::Vertx::Future, nil)
      end
      raise ArgumentError, "Invalid arguments when calling map(#{param_1})"
    end
    #  Map the result of a future to <code>null</code>.<p>
    # 
    #  This is a conveniency for <code>future.map((T) null)</code> or <code>future.map((Void) null)</code>.<p>
    # 
    #  When this future succeeds, <code>null</code> will complete the future returned by this method call.<p>
    # 
    #  When this future fails, the failure will be propagated to the returned future.
    # @return [::Vertx::Future] the mapped future
    def map_empty
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:mapEmpty, []).call(),::Vertx::Future, nil)
      end
      raise ArgumentError, "Invalid arguments when calling map_empty()"
    end
    #  Handles a failure of this Future by returning the result of another Future.
    #  If the mapper fails, then the returned future will be failed with this failure.
    # @yield A function which takes the exception of a failure and returns a new future.
    # @return [::Vertx::Future] A recovered future
    def recover(mapper=nil)
      if block_given? && mapper == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:recover, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)).j_del unless !block_given? })),::Vertx::Future,::Vertx::CompositeFuture.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling recover(#{mapper})"
    end
    #  Map the failure of a future to a specific <code>value</code>.<p>
    # 
    #  When this future fails, this <code>value</code> will complete the future returned by this method call.<p>
    # 
    #  When this future succeeds, the result will be propagated to the returned future.
    # @overload otherwise(mapper)
    #   @yield the mapper function
    # @overload otherwise(value)
    #   @param [::Vertx::CompositeFuture] value the value that eventually completes the mapped future
    # @return [::Vertx::Future] the mapped future
    def otherwise(param_1=nil)
      if block_given? && param_1 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:otherwise, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)).j_del unless !block_given? })),::Vertx::Future,::Vertx::CompositeFuture.j_api_type)
      elsif param_1.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:otherwise, [Java::IoVertxCore::CompositeFuture.java_class]).call(param_1.j_del),::Vertx::Future,::Vertx::CompositeFuture.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling otherwise(#{param_1})"
    end
    #  Map the failure of a future to <code>null</code>.<p>
    # 
    #  This is a convenience for <code>future.otherwise((T) null)</code>.<p>
    # 
    #  When this future fails, the <code>null</code> value will complete the future returned by this method call.<p>
    # 
    #  When this future succeeds, the result will be propagated to the returned future.
    # @return [::Vertx::Future] the mapped future
    def otherwise_empty
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:otherwiseEmpty, []).call(),::Vertx::Future,::Vertx::CompositeFuture.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling otherwise_empty()"
    end
    #  Like {::Vertx::CompositeFuture#all} but with 6 futures.
    # @overload all(futures)
    #   @param [Array<::Vertx::Future>] futures 
    # @overload all(f1,f2)
    #   @param [::Vertx::Future] f1 future
    #   @param [::Vertx::Future] f2 future
    # @overload all(f1,f2,f3)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    # @overload all(f1,f2,f3,f4)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    #   @param [::Vertx::Future] f4 
    # @overload all(f1,f2,f3,f4,f5)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    #   @param [::Vertx::Future] f4 
    #   @param [::Vertx::Future] f5 
    # @overload all(f1,f2,f3,f4,f5,f6)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    #   @param [::Vertx::Future] f4 
    #   @param [::Vertx::Future] f5 
    #   @param [::Vertx::Future] f6 
    # @return [::Vertx::CompositeFuture]
    def self.all(param_1=nil,param_2=nil,param_3=nil,param_4=nil,param_5=nil,param_6=nil)
      if param_1.class == Array && !block_given? && param_2 == nil && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:all, [Java::JavaUtil::List.java_class]).call(param_1.map { |element| element.j_del }),::Vertx::CompositeFuture)
      elsif param_1.class.method_defined?(:j_del) && param_2.class.method_defined?(:j_del) && !block_given? && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:all, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(param_1.j_del,param_2.j_del),::Vertx::CompositeFuture)
      elsif param_1.class.method_defined?(:j_del) && param_2.class.method_defined?(:j_del) && param_3.class.method_defined?(:j_del) && !block_given? && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:all, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(param_1.j_del,param_2.j_del,param_3.j_del),::Vertx::CompositeFuture)
      elsif param_1.class.method_defined?(:j_del) && param_2.class.method_defined?(:j_del) && param_3.class.method_defined?(:j_del) && param_4.class.method_defined?(:j_del) && !block_given? && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:all, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(param_1.j_del,param_2.j_del,param_3.j_del,param_4.j_del),::Vertx::CompositeFuture)
      elsif param_1.class.method_defined?(:j_del) && param_2.class.method_defined?(:j_del) && param_3.class.method_defined?(:j_del) && param_4.class.method_defined?(:j_del) && param_5.class.method_defined?(:j_del) && !block_given? && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:all, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(param_1.j_del,param_2.j_del,param_3.j_del,param_4.j_del,param_5.j_del),::Vertx::CompositeFuture)
      elsif param_1.class.method_defined?(:j_del) && param_2.class.method_defined?(:j_del) && param_3.class.method_defined?(:j_del) && param_4.class.method_defined?(:j_del) && param_5.class.method_defined?(:j_del) && param_6.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:all, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(param_1.j_del,param_2.j_del,param_3.j_del,param_4.j_del,param_5.j_del,param_6.j_del),::Vertx::CompositeFuture)
      end
      raise ArgumentError, "Invalid arguments when calling all(#{param_1},#{param_2},#{param_3},#{param_4},#{param_5},#{param_6})"
    end
    #  Like {::Vertx::CompositeFuture#any} but with 6 futures.
    # @overload any(futures)
    #   @param [Array<::Vertx::Future>] futures 
    # @overload any(f1,f2)
    #   @param [::Vertx::Future] f1 future
    #   @param [::Vertx::Future] f2 future
    # @overload any(f1,f2,f3)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    # @overload any(f1,f2,f3,f4)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    #   @param [::Vertx::Future] f4 
    # @overload any(f1,f2,f3,f4,f5)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    #   @param [::Vertx::Future] f4 
    #   @param [::Vertx::Future] f5 
    # @overload any(f1,f2,f3,f4,f5,f6)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    #   @param [::Vertx::Future] f4 
    #   @param [::Vertx::Future] f5 
    #   @param [::Vertx::Future] f6 
    # @return [::Vertx::CompositeFuture]
    def self.any(param_1=nil,param_2=nil,param_3=nil,param_4=nil,param_5=nil,param_6=nil)
      if param_1.class == Array && !block_given? && param_2 == nil && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:any, [Java::JavaUtil::List.java_class]).call(param_1.map { |element| element.j_del }),::Vertx::CompositeFuture)
      elsif param_1.class.method_defined?(:j_del) && param_2.class.method_defined?(:j_del) && !block_given? && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:any, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(param_1.j_del,param_2.j_del),::Vertx::CompositeFuture)
      elsif param_1.class.method_defined?(:j_del) && param_2.class.method_defined?(:j_del) && param_3.class.method_defined?(:j_del) && !block_given? && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:any, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(param_1.j_del,param_2.j_del,param_3.j_del),::Vertx::CompositeFuture)
      elsif param_1.class.method_defined?(:j_del) && param_2.class.method_defined?(:j_del) && param_3.class.method_defined?(:j_del) && param_4.class.method_defined?(:j_del) && !block_given? && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:any, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(param_1.j_del,param_2.j_del,param_3.j_del,param_4.j_del),::Vertx::CompositeFuture)
      elsif param_1.class.method_defined?(:j_del) && param_2.class.method_defined?(:j_del) && param_3.class.method_defined?(:j_del) && param_4.class.method_defined?(:j_del) && param_5.class.method_defined?(:j_del) && !block_given? && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:any, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(param_1.j_del,param_2.j_del,param_3.j_del,param_4.j_del,param_5.j_del),::Vertx::CompositeFuture)
      elsif param_1.class.method_defined?(:j_del) && param_2.class.method_defined?(:j_del) && param_3.class.method_defined?(:j_del) && param_4.class.method_defined?(:j_del) && param_5.class.method_defined?(:j_del) && param_6.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:any, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(param_1.j_del,param_2.j_del,param_3.j_del,param_4.j_del,param_5.j_del,param_6.j_del),::Vertx::CompositeFuture)
      end
      raise ArgumentError, "Invalid arguments when calling any(#{param_1},#{param_2},#{param_3},#{param_4},#{param_5},#{param_6})"
    end
    #  Like {::Vertx::CompositeFuture#join} but with 6 futures.
    # @overload join(futures)
    #   @param [Array<::Vertx::Future>] futures 
    # @overload join(f1,f2)
    #   @param [::Vertx::Future] f1 future
    #   @param [::Vertx::Future] f2 future
    # @overload join(f1,f2,f3)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    # @overload join(f1,f2,f3,f4)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    #   @param [::Vertx::Future] f4 
    # @overload join(f1,f2,f3,f4,f5)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    #   @param [::Vertx::Future] f4 
    #   @param [::Vertx::Future] f5 
    # @overload join(f1,f2,f3,f4,f5,f6)
    #   @param [::Vertx::Future] f1 
    #   @param [::Vertx::Future] f2 
    #   @param [::Vertx::Future] f3 
    #   @param [::Vertx::Future] f4 
    #   @param [::Vertx::Future] f5 
    #   @param [::Vertx::Future] f6 
    # @return [::Vertx::CompositeFuture]
    def self.join(param_1=nil,param_2=nil,param_3=nil,param_4=nil,param_5=nil,param_6=nil)
      if param_1.class == Array && !block_given? && param_2 == nil && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:join, [Java::JavaUtil::List.java_class]).call(param_1.map { |element| element.j_del }),::Vertx::CompositeFuture)
      elsif param_1.class.method_defined?(:j_del) && param_2.class.method_defined?(:j_del) && !block_given? && param_3 == nil && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:join, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(param_1.j_del,param_2.j_del),::Vertx::CompositeFuture)
      elsif param_1.class.method_defined?(:j_del) && param_2.class.method_defined?(:j_del) && param_3.class.method_defined?(:j_del) && !block_given? && param_4 == nil && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:join, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(param_1.j_del,param_2.j_del,param_3.j_del),::Vertx::CompositeFuture)
      elsif param_1.class.method_defined?(:j_del) && param_2.class.method_defined?(:j_del) && param_3.class.method_defined?(:j_del) && param_4.class.method_defined?(:j_del) && !block_given? && param_5 == nil && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:join, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(param_1.j_del,param_2.j_del,param_3.j_del,param_4.j_del),::Vertx::CompositeFuture)
      elsif param_1.class.method_defined?(:j_del) && param_2.class.method_defined?(:j_del) && param_3.class.method_defined?(:j_del) && param_4.class.method_defined?(:j_del) && param_5.class.method_defined?(:j_del) && !block_given? && param_6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:join, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(param_1.j_del,param_2.j_del,param_3.j_del,param_4.j_del,param_5.j_del),::Vertx::CompositeFuture)
      elsif param_1.class.method_defined?(:j_del) && param_2.class.method_defined?(:j_del) && param_3.class.method_defined?(:j_del) && param_4.class.method_defined?(:j_del) && param_5.class.method_defined?(:j_del) && param_6.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::CompositeFuture.java_method(:join, [Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class,Java::IoVertxCore::Future.java_class]).call(param_1.j_del,param_2.j_del,param_3.j_del,param_4.j_del,param_5.j_del,param_6.j_del),::Vertx::CompositeFuture)
      end
      raise ArgumentError, "Invalid arguments when calling join(#{param_1},#{param_2},#{param_3},#{param_4},#{param_5},#{param_6})"
    end
    # @yield 
    # @return [self]
    def set_handler
      if true
        @j_del.java_method(:setHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::CompositeFuture) : nil) } unless !block_given?))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_handler()"
    end
    #  Returns the result of a wrapped future
    # @param [Fixnum] index the wrapped future index
    # @return [Object]
    def result_at(index=nil)
      if index.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:resultAt, [Java::int.java_class]).call(index))
      end
      raise ArgumentError, "Invalid arguments when calling result_at(#{index})"
    end
    # @return [Fixnum] the number of wrapped future
    def size
      if !block_given?
        return @j_del.java_method(:size, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling size()"
    end
  end
end
