require 'vertx/pipe'
require 'vertx/web_socket_base'
require 'vertx/buffer'
require 'vertx/write_stream'
require 'vertx/promise'
require 'vertx/multi_map'
require 'vertx/future'
require 'vertx/web_socket_frame'
require 'vertx/socket_address'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.http.ServerWebSocket
module Vertx
  #  Represents a server side WebSocket.
  #  <p>
  #  Instances of this class are passed into a {::Vertx::HttpServer#websocket_handler} or provided
  #  when a WebSocket handshake is manually {::Vertx::HttpServerRequest#upgrade}ed.
  class ServerWebSocket
    include ::Vertx::WebSocketBase
    # @private
    # @param j_del [::Vertx::ServerWebSocket] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::ServerWebSocket] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ServerWebSocket
    end
    def @@j_api_type.wrap(obj)
      ServerWebSocket.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreHttp::ServerWebSocket.java_class
    end
    #  Same as  but with an <code>handler</code> called when the operation completes
    # @param [::Vertx::Buffer] data 
    # @yield 
    # @return [void]
    def write(data=nil)
      if data.class.method_defined?(:j_del) && true
        return @j_del.java_method(:write, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(data.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling write(#{data})"
    end
    #  Same as  but with an <code>handler</code> called when the operation completes
    # @param [::Vertx::Buffer] data 
    # @yield 
    # @return [void]
    def end(data=nil)
      if true && data == nil
        return @j_del.java_method(:end, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
      elsif data.class.method_defined?(:j_del) && true
        return @j_del.java_method(:end, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(data.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling end(#{data})"
    end
    #  This will return <code>true</code> if there are more bytes in the write queue than the value set using {::Vertx::ServerWebSocket#set_write_queue_max_size}
    # @return [true,false] true if write queue is full
    def write_queue_full?
      if !block_given?
        return @j_del.java_method(:writeQueueFull, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling write_queue_full?()"
    end
    #  Pause this stream and return a  to transfer the elements of this stream to a destination .
    #  <p/>
    #  The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
    # @return [::Vertx::Pipe] a pipe
    def pipe
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pipe, []).call(),::Vertx::Pipe,::Vertx::Buffer.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling pipe()"
    end
    #  Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
    #  <p>
    #  Elements emitted by this stream will be written to the write stream until this stream ends or fails.
    #  <p>
    #  Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
    #  called with the result.
    # @param [::Vertx::WriteStream] dst the destination write stream
    # @yield 
    # @return [void]
    def pipe_to(dst=nil)
      if dst.class.method_defined?(:j_del) && true
        return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(dst.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling pipe_to(#{dst})"
    end
    #  When a <code>WebSocket</code> is created it automatically registers an event handler with the event bus - the ID of that
    #  handler is given by this method.
    #  <p>
    #  Given this ID, a different event loop can send a binary frame to that event handler using the event bus and
    #  that buffer will be received by this instance in its own event loop and written to the underlying connection. This
    #  allows you to write data to other WebSockets which are owned by different event loops.
    # @return [String] the binary handler id
    def binary_handler_id
      if !block_given?
        return @j_del.java_method(:binaryHandlerID, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling binary_handler_id()"
    end
    #  When a <code>WebSocket</code> is created it automatically registers an event handler with the eventbus, the ID of that
    #  handler is given by <code>textHandlerID</code>.
    #  <p>
    #  Given this ID, a different event loop can send a text frame to that event handler using the event bus and
    #  that buffer will be received by this instance in its own event loop and written to the underlying connection. This
    #  allows you to write data to other WebSockets which are owned by different event loops.
    # @return [String]
    def text_handler_id
      if !block_given?
        return @j_del.java_method(:textHandlerID, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling text_handler_id()"
    end
    #  Returns the WebSocket sub protocol selected by the WebSocket handshake.
    #  <p/>
    #  On the server, the value will be <code>null</code> when the handler receives the websocket callback as the
    #  handshake will not be completed yet.
    # @return [String]
    def sub_protocol
      if !block_given?
        return @j_del.java_method(:subProtocol, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling sub_protocol()"
    end
    # @param [::Vertx::WebSocketFrame] frame 
    # @yield 
    # @return [self]
    def write_frame(frame=nil)
      if frame.class.method_defined?(:j_del) && true
        @j_del.java_method(:writeFrame, [Java::IoVertxCoreHttp::WebSocketFrame.java_class,Java::IoVertxCore::Handler.java_class]).call(frame.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling write_frame(#{frame})"
    end
    # @param [String] text 
    # @yield 
    # @return [self]
    def write_final_text_frame(text=nil)
      if text.class == String && true
        @j_del.java_method(:writeFinalTextFrame, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(text,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling write_final_text_frame(#{text})"
    end
    # @param [::Vertx::Buffer] data 
    # @yield 
    # @return [self]
    def write_final_binary_frame(data=nil)
      if data.class.method_defined?(:j_del) && true
        @j_del.java_method(:writeFinalBinaryFrame, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(data.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling write_final_binary_frame(#{data})"
    end
    # @param [::Vertx::Buffer] data 
    # @yield 
    # @return [self]
    def write_binary_message(data=nil)
      if data.class.method_defined?(:j_del) && true
        @j_del.java_method(:writeBinaryMessage, [Java::IoVertxCoreBuffer::Buffer.java_class,Java::IoVertxCore::Handler.java_class]).call(data.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling write_binary_message(#{data})"
    end
    # @param [String] text 
    # @yield 
    # @return [self]
    def write_text_message(text=nil)
      if text.class == String && true
        @j_del.java_method(:writeTextMessage, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(text,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling write_text_message(#{text})"
    end
    #  Writes a ping frame to the connection. This will be written in a single frame. Ping frames may be at most 125 bytes (octets).
    #  <p>
    #  This method should not be used to write application data and should only be used for implementing a keep alive or
    #  to ensure the client is still responsive, see RFC 6455 Section <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
    #  <p>
    #  There is no handler for ping frames because RFC 6455  clearly
    #  states that the only response to a ping frame is a pong frame with identical contents.
    # @param [::Vertx::Buffer] data the data to write, may be at most 125 bytes
    # @return [self]
    def write_ping(data=nil)
      if data.class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:writePing, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(data.j_del)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling write_ping(#{data})"
    end
    #  Writes a pong frame to the connection. This will be written in a single frame. Pong frames may be at most 125 bytes (octets).
    #  <p>
    #  This method should not be used to write application data and should only be used for implementing a keep alive or
    #  to ensure the client is still responsive, see RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
    #  <p>
    #  There is no need to manually write a pong frame, as the server and client both handle responding to a ping from with a pong from
    #  automatically and this is exposed to users. RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> states that pongs may be sent unsolicited in order
    #  to implement a one way heartbeat.
    # @param [::Vertx::Buffer] data the data to write, may be at most 125 bytes
    # @return [self]
    def write_pong(data=nil)
      if data.class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:writePong, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(data.j_del)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling write_pong(#{data})"
    end
    #  Set a text message handler on the connection. This handler will be called similar to the
    #  , but the buffer will be converted to a String first
    # @yield the handler
    # @return [self]
    def text_message_handler
      if true
        @j_del.java_method(:textMessageHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event) unless !block_given? }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling text_message_handler()"
    end
    #  Set a binary message handler on the connection. This handler serves a similar purpose to {::Vertx::ServerWebSocket#handler}
    #  except that if a message comes into the socket in multiple frames, the data from the frames will be aggregated
    #  into a single buffer before calling the handler (using {::Vertx::WebSocketFrame#is_final} to find the boundaries).
    # @yield the handler
    # @return [self]
    def binary_message_handler
      if true
        @j_del.java_method(:binaryMessageHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer)) unless !block_given? }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling binary_message_handler()"
    end
    #  Set a pong frame handler on the connection.  This handler will be invoked every time a pong frame is received
    #  on the server, and can be used by both clients and servers since the RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a> and <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> do not
    #  specify whether the client or server sends a ping.
    #  <p>
    #  Pong frames may be at most 125 bytes (octets).
    #  <p>
    #  There is no ping handler since ping frames should immediately be responded to with a pong frame with identical content
    #  <p>
    #  Pong frames may be received unsolicited.
    # @yield the handler
    # @return [self]
    def pong_handler
      if true
        @j_del.java_method(:pongHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer)) unless !block_given? }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pong_handler()"
    end
    #  Same as  but with an <code>handler</code> called when the operation completes
    # @param [Fixnum] statusCode 
    # @param [String] reason 
    # @yield 
    # @return [void]
    def close(statusCode=nil,reason=nil)
      if true && statusCode == nil && reason == nil
        return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
      elsif statusCode.class == Fixnum && true && reason == nil
        return @j_del.java_method(:close, [Java::short.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_short(statusCode),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
      elsif statusCode.class == Fixnum && reason.class == String && true
        return @j_del.java_method(:close, [Java::short.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_short(statusCode),reason,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling close(#{statusCode},#{reason})"
    end
    # @return [::Vertx::SocketAddress] the remote address for this socket
    def remote_address
      if !block_given?
        if @cached_remote_address != nil
          return @cached_remote_address
        end
        return @cached_remote_address = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:remoteAddress, []).call(),::Vertx::SocketAddress)
      end
      raise ArgumentError, "Invalid arguments when calling remote_address()"
    end
    # @return [::Vertx::SocketAddress] the local address for this socket
    def local_address
      if !block_given?
        if @cached_local_address != nil
          return @cached_local_address
        end
        return @cached_local_address = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:localAddress, []).call(),::Vertx::SocketAddress)
      end
      raise ArgumentError, "Invalid arguments when calling local_address()"
    end
    # @return [true,false] true if this {::Vertx::HttpConnection} is encrypted via SSL/TLS.
    def ssl?
      if !block_given?
        return @j_del.java_method(:isSsl, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling ssl?()"
    end
    # @return [true,false] <code>true</code> if the WebSocket is closed
    def closed?
      if !block_given?
        return @j_del.java_method(:isClosed, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling closed?()"
    end
    # @yield 
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
    # @yield 
    # @return [self]
    def handler
      if true
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer)) unless !block_given? }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling handler()"
    end
    # @return [self]
    def pause
      if !block_given?
        @j_del.java_method(:pause, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pause()"
    end
    # @return [self]
    def resume
      if !block_given?
        @j_del.java_method(:resume, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling resume()"
    end
    # @param [Fixnum] amount 
    # @return [self]
    def fetch(amount=nil)
      if amount.class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(amount)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling fetch(#{amount})"
    end
    # @yield 
    # @return [self]
    def end_handler
      if true
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield unless !block_given? })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling end_handler()"
    end
    # @param [Fixnum] maxSize 
    # @return [self]
    def set_write_queue_max_size(maxSize=nil)
      if maxSize.class == Fixnum && !block_given?
        @j_del.java_method(:setWriteQueueMaxSize, [Java::int.java_class]).call(maxSize)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_write_queue_max_size(#{maxSize})"
    end
    # @yield 
    # @return [self]
    def drain_handler
      if true
        @j_del.java_method(:drainHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield unless !block_given? })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling drain_handler()"
    end
    # @yield 
    # @return [self]
    def close_handler
      if true
        @j_del.java_method(:closeHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield unless !block_given? })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling close_handler()"
    end
    # @yield 
    # @return [self]
    def frame_handler
      if true
        @j_del.java_method(:frameHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::WebSocketFrame)) unless !block_given? }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling frame_handler()"
    end
    # @return [String]
    def uri
      if !block_given?
        return @j_del.java_method(:uri, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling uri()"
    end
    # @return [String] the WebSocket handshake path.
    def path
      if !block_given?
        return @j_del.java_method(:path, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling path()"
    end
    # @return [String] the WebSocket handshake query string.
    def query
      if !block_given?
        return @j_del.java_method(:query, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling query()"
    end
    # @return [::Vertx::MultiMap] the headers in the WebSocket handshake
    def headers
      if !block_given?
        if @cached_headers != nil
          return @cached_headers
        end
        return @cached_headers = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:headers, []).call(),::Vertx::MultiMap)
      end
      raise ArgumentError, "Invalid arguments when calling headers()"
    end
    #  Accept the WebSocket and terminate the WebSocket handshake.
    #  <p/>
    #  This method should be called from the WebSocket handler to explicitly accept the WebSocket and
    #  terminate the WebSocket handshake.
    # @return [void]
    def accept
      if !block_given?
        return @j_del.java_method(:accept, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling accept()"
    end
    #  Like {::Vertx::ServerWebSocket#reject} but with a <code>status</code>.
    # @param [Fixnum] status 
    # @return [void]
    def reject(status=nil)
      if !block_given? && status == nil
        return @j_del.java_method(:reject, []).call()
      elsif status.class == Fixnum && !block_given?
        return @j_del.java_method(:reject, [Java::int.java_class]).call(status)
      end
      raise ArgumentError, "Invalid arguments when calling reject(#{status})"
    end
    #  Set an asynchronous result for the handshake, upon completion of the specified <code>future</code>, the
    #  WebSocket will either be
    # 
    #  <ul>
    #    <li>accepted when the <code>future</code> succeeds with the HTTP  status code</li>
    #    <li>rejected when the <code>future</code> is succeeds with an HTTP status code different than </li>
    #    <li>rejected when the <code>future</code> fails with the HTTP status code <code>500</code></li>
    #  </ul>
    # 
    #  The provided future might be completed by the WebSocket itself, e.g calling the {::Vertx::ServerWebSocket#close} method
    #  will try to accept the handshake and close the WebSocket afterward. Thus it is advised to try to complete
    #  the <code>future</code> with  or .
    #  <p>
    #  This method should be called from the WebSocket handler to explicitly set an asynchronous handshake.
    #  <p>
    #  Calling this method will override the <code>future</code> completion handler.
    # @param [::Vertx::Promise] future the future to complete with
    # @return [void]
    def set_handshake(future=nil)
      if future.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:setHandshake, [Java::IoVertxCore::Promise.java_class]).call(future.j_del)
      end
      raise ArgumentError, "Invalid arguments when calling set_handshake(#{future})"
    end
  end
end
