require 'vertx/pipe'
require 'vertx/write_stream'
require 'vertx/read_stream'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.TimeoutStream
module Vertx
  #  A timeout stream is triggered by a timer, the {Proc} will be call when the timer is fired,
  #  it can be once or several times depending on the nature of the timer related to this stream. The
  #   will be called after the timer handler has been called.
  #  <p>
  #  Pausing the timer inhibits the timer shots until the stream is resumed. Setting a null handler callback cancels
  #  the timer.
  class TimeoutStream
    include ::Vertx::ReadStream
    # @private
    # @param j_del [::Vertx::TimeoutStream] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::TimeoutStream] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == TimeoutStream
    end
    def @@j_api_type.wrap(obj)
      TimeoutStream.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCore::TimeoutStream.java_class
    end
    #  Pause this stream and return a  to transfer the elements of this stream to a destination .
    #  <p/>
    #  The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
    # @return [::Vertx::Pipe] a pipe
    def pipe
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pipe, []).call(),::Vertx::Pipe, nil)
      end
      raise ArgumentError, "Invalid arguments when calling pipe()"
    end
    #  Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
    #  <p>
    #  Elements emitted by this stream will be written to the write stream until this stream ends or fails.
    #  <p>
    #  Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
    #  called with the result.
    # @param [::Vertx::WriteStream] dst the destination write stream
    # @yield 
    # @return [void]
    def pipe_to(dst=nil)
      if dst.class.method_defined?(:j_del) && true
        return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(dst.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling pipe_to(#{dst})"
    end
    # @yield 
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
    # @yield 
    # @return [self]
    def handler
      if true
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event) unless !block_given? }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling handler()"
    end
    # @return [self]
    def pause
      if !block_given?
        @j_del.java_method(:pause, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pause()"
    end
    # @return [self]
    def resume
      if !block_given?
        @j_del.java_method(:resume, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling resume()"
    end
    # @param [Fixnum] amount 
    # @return [self]
    def fetch(amount=nil)
      if amount.class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(amount)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling fetch(#{amount})"
    end
    # @yield 
    # @return [self]
    def end_handler
      if true
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield unless !block_given? })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling end_handler()"
    end
    #  Cancels the timeout. Note this has the same effect as calling {::Vertx::TimeoutStream#handler} with a null
    #  argument.
    # @return [void]
    def cancel
      if !block_given?
        return @j_del.java_method(:cancel, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling cancel()"
    end
  end
end
