require 'vertx/stream_base'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.streams.WriteStream
module Vertx
  module WriteStream
    include ::Vertx::StreamBase
    #  Set an exception handler on the write stream.
    # @yield the exception handler
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
    #  Same as  but with an <code>handler</code> called when the operation completes
    # @param [Object] data 
    # @yield 
    # @return [void]
    def write(data=nil)
      if @j_arg_T.accept?(data) && true
        return @j_del.java_method(:write, [Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(@j_arg_T.unwrap(data),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling write(#{data})"
    end
    #  Same as  but with an <code>handler</code> called when the operation completes
    # @param [Object] data 
    # @yield 
    # @return [void]
    def end(data=nil)
      if true && data == nil
        return @j_del.java_method(:end, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
      elsif @j_arg_T.accept?(data) && true
        return @j_del.java_method(:end, [Java::java.lang.Object.java_class,Java::IoVertxCore::Handler.java_class]).call(@j_arg_T.unwrap(data),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling end(#{data})"
    end
    #  Set the maximum size of the write queue to <code>maxSize</code>. You will still be able to write to the stream even
    #  if there is more than <code>maxSize</code> items in the write queue. This is used as an indicator by classes such as
    #  <code>Pump</code> to provide flow control.
    #  <p/>
    #  The value is defined by the implementation of the stream, e.g in bytes for a
    #  {::Vertx::NetSocket}, the number of {::Vertx::Message} for a
    #  {::Vertx::MessageProducer}, etc...
    # @param [Fixnum] maxSize the max size of the write stream
    # @return [self]
    def set_write_queue_max_size(maxSize=nil)
      if maxSize.class == Fixnum && !block_given?
        @j_del.java_method(:setWriteQueueMaxSize, [Java::int.java_class]).call(maxSize)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_write_queue_max_size(#{maxSize})"
    end
    #  This will return <code>true</code> if there are more bytes in the write queue than the value set using {::Vertx::WriteStream#set_write_queue_max_size}
    # @return [true,false] true if write queue is full
    def write_queue_full?
      if !block_given?
        return @j_del.java_method(:writeQueueFull, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling write_queue_full?()"
    end
    #  Set a drain handler on the stream. If the write queue is full, then the handler will be called when the write
    #  queue is ready to accept buffers again. See {::Vertx::Pump} for an example of this being used.
    #  <p/>
    #  The stream implementation defines when the drain handler, for example it could be when the queue size has been
    #  reduced to <code>maxSize / 2</code>.
    # @yield the handler
    # @return [self]
    def drain_handler
      if true
        @j_del.java_method(:drainHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield unless !block_given? })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling drain_handler()"
    end
  end
  class WriteStreamImpl
    include WriteStream
    # @private
    # @param j_del [::Vertx::WriteStream] the java delegate
    def initialize(j_del, j_arg_T=nil)
      @j_del = j_del
      @j_arg_T = j_arg_T != nil ? j_arg_T : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::Vertx::WriteStream] the underlying java delegate
    def j_del
      @j_del
    end
  end
end
