require 'vertx/vertx'
require 'vertx-auth-common/auth_provider'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.htpasswd.HtpasswdAuth
module VertxAuthHtpasswd
  #  An extension of AuthProvider which is using htpasswd file as store
  class HtpasswdAuth < ::VertxAuthCommon::AuthProvider
    # @private
    # @param j_del [::VertxAuthHtpasswd::HtpasswdAuth] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthHtpasswd::HtpasswdAuth] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == HtpasswdAuth
    end
    def @@j_api_type.wrap(obj)
      HtpasswdAuth.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthHtpasswd::HtpasswdAuth.java_class
    end
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx 
    # @overload create(vertx,htpasswdAuthOptions)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [Hash{String => Object}] htpasswdAuthOptions 
    # @return [::VertxAuthHtpasswd::HtpasswdAuth]
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthHtpasswd::HtpasswdAuth.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxAuthHtpasswd::HtpasswdAuth)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthHtpasswd::HtpasswdAuth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtAuthHtpasswd::HtpasswdAuthOptions.java_class]).call(args[0].j_del,Java::IoVertxExtAuthHtpasswd::HtpasswdAuthOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxAuthHtpasswd::HtpasswdAuth)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
  end
end
