require 'vertx/vertx'
require 'vertx-auth-common/auth_provider'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.shiro.ShiroAuth
module VertxAuthShiro
  #  Factory interface for creating Apache Shiro based {::VertxAuthCommon::AuthProvider} instances.
  class ShiroAuth < ::VertxAuthCommon::AuthProvider
    # @private
    # @param j_del [::VertxAuthShiro::ShiroAuth] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthShiro::ShiroAuth] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ShiroAuth
    end
    def @@j_api_type.wrap(obj)
      ShiroAuth.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthShiro::ShiroAuth.java_class
    end
    #  Set the role prefix to distinguish from permissions when checking for isPermitted requests.
    # @overload setRolePrefix(rolePrefix)
    #   @param [String] rolePrefix a Prefix e.g.: "role:"
    # @return [::VertxAuthShiro::ShiroAuth] a reference to this for fluency
    def set_role_prefix(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:setRolePrefix, [Java::java.lang.String.java_class]).call(args[0]),::VertxAuthShiro::ShiroAuth)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_role_prefix(#{args[0]})"
      end
    end
    #  Create a Shiro auth provider
    # @overload create(vertx,options)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    #   @param [Hash{String => Object}] options the Shiro configuration options
    # @overload create(vertx,realmType,config)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    #   @param [:PROPERTIES,:LDAP] realmType the Shiro realm type
    #   @param [Hash{String => Object}] config the config
    # @return [::VertxAuthShiro::ShiroAuth] the auth provider
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthShiro::ShiroAuth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtAuthShiro::ShiroAuthOptions.java_class]).call(args[0].j_del,Java::IoVertxExtAuthShiro::ShiroAuthOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxAuthShiro::ShiroAuth)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Symbol && args[2].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthShiro::ShiroAuth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtAuthShiro::ShiroAuthRealmType.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0].j_del,Java::IoVertxExtAuthShiro::ShiroAuthRealmType.valueOf(args[1].to_s),::Vertx::Util::Utils.to_json_object(args[2])),::VertxAuthShiro::ShiroAuth)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  The default role prefix
    def self.DEFAULT_ROLE_PREFIX
      Java::IoVertxExtAuthShiro::ShiroAuth.DEFAULT_ROLE_PREFIX
    end
  end
end
