require 'vertx/write_stream'
require 'vertx/vertx'
require 'vertx/future'
require 'vertx-kafka-client/kafka_producer_record'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.kafka.client.producer.KafkaProducer
module VertxKafkaClient
  #  Vert.x Kafka producer.
  #  <p>
  #  The {::Vertx::WriteStream#write} provides global control over writing a record.
  class KafkaProducer
    include ::Vertx::WriteStream
    # @private
    # @param j_del [::VertxKafkaClient::KafkaProducer] the java delegate
    def initialize(j_del, j_arg_K=nil, j_arg_V=nil)
      @j_del = j_del
      @j_arg_K = j_arg_K != nil ? j_arg_K : ::Vertx::Util::unknown_type
      @j_arg_V = j_arg_V != nil ? j_arg_V : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::VertxKafkaClient::KafkaProducer] the underlying java delegate
    def j_del
      @j_del
    end
    #  Invoking this method makes all buffered records immediately available to write
    # @overload flush(completionHandler)
    #   @yield handler called on operation completed
    # @return [self]
    def flush
      if true
        if (block_given?)
          @j_del.java_method(:flush, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:flush, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling flush()"
      end
    end
    # @overload drainHandler(handler)
    #   @yield 
    # @return [self]
    def drain_handler
      if true
        @j_del.java_method(:drainHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling drain_handler()"
      end
    end
    #  Get the partition metadata for the give topic.
    # @overload partitionsFor(topic,handler)
    #   @param [String] topic topic partition for which getting partitions info
    #   @yield handler called on operation completed
    # @return [self]
    def partitions_for(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:partitionsFor, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:partitionsFor, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.toJson.encode) : nil } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling partitions_for(#{args[0]})"
      end
    end
    #  This will return <code>true</code> if there are more bytes in the write queue than the value set using {::VertxKafkaClient::KafkaProducer#set_write_queue_max_size}
    # @overload writeQueueFull()
    # @return [true,false] true if write queue is full
    def write_queue_full?
      if !block_given?
        return @j_del.java_method(:writeQueueFull, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write_queue_full?()"
      end
    end
    #  Get or create a KafkaProducer instance which shares its stream with any other KafkaProducer created with the same <code>name</code>
    # @overload createShared(vertx,name,config)
    #   @param [::Vertx::Vertx] vertx Vert.x instance to use
    #   @param [String] name the producer name to identify it
    #   @param [Hash{String => String}] config Kafka producer configuration
    # @overload createShared(vertx,name,config,keyType,valueType)
    #   @param [::Vertx::Vertx] vertx Vert.x instance to use
    #   @param [String] name the producer name to identify it
    #   @param [Hash{String => String}] config Kafka producer configuration
    #   @param [Nil] keyType class type for the key serialization
    #   @param [Nil] valueType class type for the value serialization
    # @return [::VertxKafkaClient::KafkaProducer] an instance of the KafkaProducer
    def self.create_shared(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == String && args[2].class == Hash && !block_given? && args[3] == nil && args[4] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxKafkaClientProducer::KafkaProducer.java_method(:createShared, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::JavaUtil::Map.java_class]).call(args[0].j_del,args[1],Hash[args[2].map { |k,v| [k,v] }]),::VertxKafkaClient::KafkaProducer, nil, nil)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == String && args[2].class == Hash && args[3].class == Class && args[4].class == Class && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxKafkaClientProducer::KafkaProducer.java_method(:createShared, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::JavaUtil::Map.java_class,Java::JavaLang::Class.java_class,Java::JavaLang::Class.java_class]).call(args[0].j_del,args[1],Hash[args[2].map { |k,v| [k,v] }],::Vertx::Util::Utils.j_class_of(args[3]),::Vertx::Util::Utils.j_class_of(args[4])),::VertxKafkaClient::KafkaProducer, ::Vertx::Util::Utils.v_type_of(args[3]), ::Vertx::Util::Utils.v_type_of(args[4]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_shared(#{args[0]},#{args[1]},#{args[2]},#{args[3]},#{args[4]})"
      end
    end
    #  Create a new KafkaProducer instance
    # @overload create(vertx,config)
    #   @param [::Vertx::Vertx] vertx Vert.x instance to use
    #   @param [Hash{String => String}] config Kafka producer configuration
    # @overload create(vertx,config,keyType,valueType)
    #   @param [::Vertx::Vertx] vertx Vert.x instance to use
    #   @param [Hash{String => String}] config Kafka producer configuration
    #   @param [Nil] keyType class type for the key serialization
    #   @param [Nil] valueType class type for the value serialization
    # @return [::VertxKafkaClient::KafkaProducer] an instance of the KafkaProducer
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given? && args[2] == nil && args[3] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxKafkaClientProducer::KafkaProducer.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::JavaUtil::Map.java_class]).call(args[0].j_del,Hash[args[1].map { |k,v| [k,v] }]),::VertxKafkaClient::KafkaProducer, nil, nil)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && args[2].class == Class && args[3].class == Class && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxKafkaClientProducer::KafkaProducer.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::JavaUtil::Map.java_class,Java::JavaLang::Class.java_class,Java::JavaLang::Class.java_class]).call(args[0].j_del,Hash[args[1].map { |k,v| [k,v] }],::Vertx::Util::Utils.j_class_of(args[2]),::Vertx::Util::Utils.j_class_of(args[3])),::VertxKafkaClient::KafkaProducer, ::Vertx::Util::Utils.v_type_of(args[2]), ::Vertx::Util::Utils.v_type_of(args[3]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  Same as  but with an <code>handler</code> called when the operation completes
    # @overload end(handler)
    #   @yield 
    # @overload end(data,handler)
    #   @param [::VertxKafkaClient::KafkaProducerRecord] data 
    #   @yield 
    # @return [void]
    def end(*args)
      if true && args[0] == nil
        if (block_given?)
          return @j_del.java_method(:end, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:end, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:end, [Java::IoVertxKafkaClientProducer::KafkaProducerRecord.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:end, [Java::IoVertxKafkaClientProducer::KafkaProducerRecord.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end(#{args[0]})"
      end
    end
    #  Close the producer
    # @overload close(completionHandler)
    #   @yield handler called on operation completed
    # @overload close(timeout,completionHandler)
    #   @param [Fixnum] timeout timeout to wait for closing
    #   @yield handler called on operation completed
    # @return [void]
    def close(*args)
      if true && args[0] == nil
        if (block_given?)
          return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == Fixnum && true
        if (block_given?)
          return @j_del.java_method(:close, [Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:close, [Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close(#{args[0]})"
      end
    end
    #  Asynchronously write a record to a topic
    # @overload send(record,handler)
    #   @param [::VertxKafkaClient::KafkaProducerRecord] record record to write
    #   @yield handler called on operation completed
    # @return [self]
    def send(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          @j_del.java_method(:send, [Java::IoVertxKafkaClientProducer::KafkaProducerRecord.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:send, [Java::IoVertxKafkaClientProducer::KafkaProducerRecord.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::Vertx::Util::data_object_type(Java::IoVertxKafkaClientProducer::RecordMetadata))
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling send(#{args[0]})"
      end
    end
    # @overload exceptionHandler(handler)
    #   @yield 
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    #  Same as  but with an <code>handler</code> called when the operation completes
    # @overload write(data,handler)
    #   @param [::VertxKafkaClient::KafkaProducerRecord] data 
    #   @yield 
    # @return [void]
    def write(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:write, [Java::IoVertxKafkaClientProducer::KafkaProducerRecord.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:write, [Java::IoVertxKafkaClientProducer::KafkaProducerRecord.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write(#{args[0]})"
      end
    end
    # @overload setWriteQueueMaxSize(i)
    #   @param [Fixnum] i 
    # @return [self]
    def set_write_queue_max_size(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:setWriteQueueMaxSize, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_write_queue_max_size(#{args[0]})"
      end
    end
  end
end
