require 'vertx-sql-client/sql_connection'
require 'vertx/vertx'
require 'vertx-sql-client/row_set'
require 'vertx-sql-client/prepared_query'
require 'vertx-sql-client/tuple'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.pgclient.PgConnection
module VertxPgClient
  #  A connection to Postgres.
  class PgConnection < ::VertxSqlClient::SqlConnection
    # @private
    # @param j_del [::VertxPgClient::PgConnection] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxPgClient::PgConnection] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == PgConnection
    end
    def @@j_api_type.wrap(obj)
      PgConnection.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxPgclient::PgConnection.java_class
    end
    # @overload prepare(sql,handler)
    #   @param [String] sql 
    #   @yield 
    # @return [self]
    def prepare(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:prepare, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::PreparedQuery) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:prepare, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::PreparedQuery) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSqlClient::PreparedQuery.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling prepare(#{args[0]})"
      end
    end
    # @overload secretKey()
    # @return [Fixnum] The secret key for the target backend
    def secret_key
      if !block_given?
        return @j_del.java_method(:secretKey, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling secret_key()"
      end
    end
    # @overload preparedBatch(sql,batch,handler)
    #   @param [String] sql 
    #   @param [Array<::VertxSqlClient::Tuple>] batch 
    #   @yield 
    # @return [self]
    def prepared_batch(*args)
      if args[0].class == String && args[1].class == Array && true
        if (block_given?)
          @j_del.java_method(:preparedBatch, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].map { |element| element.j_del },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:preparedBatch, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].map { |element| element.j_del },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSqlClient::RowSet.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling prepared_batch(#{args[0]},#{args[1]})"
      end
    end
    # @overload processId()
    # @return [Fixnum] The process ID of the target backend
    def process_id
      if !block_given?
        return @j_del.java_method(:processId, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling process_id()"
      end
    end
    # @overload query(sql,handler)
    #   @param [String] sql 
    #   @yield 
    # @return [self]
    def query(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:query, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:query, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSqlClient::RowSet.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling query(#{args[0]})"
      end
    end
    #  Send a request cancellation message to tell the server to cancel processing request in this connection.
    #  <br>Note: Use this with caution because the cancellation signal may or may not have any effect.
    # @overload cancelRequest(handler)
    #   @yield the handler notified if cancelling request is sent
    # @return [::VertxPgClient::PgConnection] a reference to this, so the API can be used fluently
    def cancel_request
      if true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:cancelRequest, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise),::VertxPgClient::PgConnection)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling cancel_request()"
      end
    end
    #  Set an handler called when the connection receives notification on a channel.
    #  <p/>
    #  The handler is called with the {Hash{String => Object}} and has access to the channel name
    #  and the notification payload.
    # @overload notificationHandler(handler)
    #   @yield the handler
    # @return [self]
    def notification_handler
      if true
        @j_del.java_method(:notificationHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event != nil ? JSON.parse(event.toJson.encode) : nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling notification_handler()"
      end
    end
    # @overload closeHandler(handler)
    #   @yield 
    # @return [self]
    def close_handler
      if true
        @j_del.java_method(:closeHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close_handler()"
      end
    end
    # @overload exceptionHandler(handler)
    #   @yield 
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
    #  Like {::VertxPgClient::PgConnection#connect} with options build from <code>connectionUri</code>.
    # @overload connect(vertx,handler)
    #   @param [::Vertx::Vertx] vertx 
    #   @yield 
    # @overload connect(vertx,options,handler)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [Hash{String => Object}] options the connect options
    #   @yield the handler called with the connection or the failure
    # @overload connect(vertx,connectionUri,handler)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] connectionUri 
    #   @yield 
    # @return [void]
    def self.connect(*args)
      if args[0].class.method_defined?(:j_del) && true && args[1] == nil
        if (block_given?)
          return Java::IoVertxPgclient::PgConnection.java_method(:connect, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxPgClient::PgConnection) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxPgclient::PgConnection.java_method(:connect, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxPgClient::PgConnection) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxPgClient::PgConnection.j_api_type)
        end
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && true
        if (block_given?)
          return Java::IoVertxPgclient::PgConnection.java_method(:connect, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxPgclient::PgConnectOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,Java::IoVertxPgclient::PgConnectOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxPgClient::PgConnection) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxPgclient::PgConnection.java_method(:connect, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxPgclient::PgConnectOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,Java::IoVertxPgclient::PgConnectOptions.new(::Vertx::Util::Utils.to_json_object(args[1])),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxPgClient::PgConnection) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxPgClient::PgConnection.j_api_type)
        end
      elsif args[0].class.method_defined?(:j_del) && args[1].class == String && true
        if (block_given?)
          return Java::IoVertxPgclient::PgConnection.java_method(:connect, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxPgClient::PgConnection) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          Java::IoVertxPgclient::PgConnection.java_method(:connect, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxPgClient::PgConnection) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxPgClient::PgConnection.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connect(#{args[0]},#{args[1]})"
      end
    end
    # @overload preparedQuery(sql,handler)
    #   @param [String] sql 
    #   @yield 
    # @overload preparedQuery(sql,arguments,handler)
    #   @param [String] sql 
    #   @param [::VertxSqlClient::Tuple] arguments 
    #   @yield 
    # @return [self]
    def prepared_query(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSqlClient::RowSet.j_api_type)
        end
      elsif args[0].class == String && args[1].class.method_defined?(:j_del) && true
        if (block_given?)
          @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxSqlclient::Tuple.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxSqlclient::Tuple.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxSqlClient::RowSet.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling prepared_query(#{args[0]},#{args[1]})"
      end
    end
  end
end
