require 'vertx-shell/command'
require 'vertx/vertx'
require 'vertx-shell/command_resolver'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.shell.command.CommandRegistry
module VertxShell
  #  A registry that contains the commands known by a shell.<p/>
  # 
  #  It is a mutable command resolver.
  class CommandRegistry < ::VertxShell::CommandResolver
    # @private
    # @param j_del [::VertxShell::CommandRegistry] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxShell::CommandRegistry] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == CommandRegistry
    end
    def @@j_api_type.wrap(obj)
      CommandRegistry.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtShellCommand::CommandRegistry.java_class
    end
    #  Get the shared registry for the Vert.x instance.
    # @overload getShared(vertx)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    # @return [::VertxShell::CommandRegistry] the shared registry
    def self.get_shared(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtShellCommand::CommandRegistry.java_method(:getShared, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxShell::CommandRegistry)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_shared(#{args[0]})"
      end
    end
    #  Create a new registry.
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    # @return [::VertxShell::CommandRegistry] the created registry
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtShellCommand::CommandRegistry.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxShell::CommandRegistry)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    #  Register a list of commands.
    # @overload registerCommands(commands)
    #   @param [Array<::VertxShell::Command>] commands 
    # @overload registerCommands(commands,completionHandler)
    #   @param [Array<::VertxShell::Command>] commands the commands to register
    #   @yield notified when the command is registered
    # @return [self]
    def register_commands(*args)
      if args[0].class == Array && !block_given?
        @j_del.java_method(:registerCommands, [Java::JavaUtil::List.java_class]).call(args[0].map { |element| element.j_del })
        return self
      elsif args[0].class == Array && true
        if (block_given?)
          @j_del.java_method(:registerCommands, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].map { |element| element.j_del },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxShell::Command) } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:registerCommands, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].map { |element| element.j_del },block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxShell::Command) } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling register_commands(#{args[0]})"
      end
    end
    #  Register a command
    # @overload registerCommand(command)
    #   @param [::VertxShell::Command] command 
    # @overload registerCommand(command,completionHandler)
    #   @param [::VertxShell::Command] command the command to register
    #   @yield notified when the command is registered
    # @return [self]
    def register_command(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:registerCommand, [Java::IoVertxExtShellCommand::Command.java_class]).call(args[0].j_del)
        return self
      elsif args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          @j_del.java_method(:registerCommand, [Java::IoVertxExtShellCommand::Command.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxShell::Command) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:registerCommand, [Java::IoVertxExtShellCommand::Command.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxShell::Command) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxShell::Command.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling register_command(#{args[0]})"
      end
    end
    #  Unregister a command.
    # @overload unregisterCommand(commandName)
    #   @param [String] commandName 
    # @overload unregisterCommand(commandName,completionHandler)
    #   @param [String] commandName the command name
    #   @yield notified when the command is unregistered
    # @return [self]
    def unregister_command(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:unregisterCommand, [Java::java.lang.String.java_class]).call(args[0])
        return self
      elsif args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:unregisterCommand, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:unregisterCommand, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling unregister_command(#{args[0]})"
      end
    end
  end
end
