require 'vertx/buffer'
require 'vertx-sql-client/tuple'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.Row
module VertxSqlClient
  class Row < ::VertxSqlClient::Tuple
    # @private
    # @param j_del [::VertxSqlClient::Row] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSqlClient::Row] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Row
    end
    def @@j_api_type.wrap(obj)
      Row.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxSqlclient::Row.java_class
    end
    #  Get a long value at <code>pos</code>.
    # @overload getLong(name)
    #   @param [String] name the column
    # @return [Fixnum] the value or <code>null</code>
    def get_long(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:getLong, [Java::java.lang.String.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_long(#{args[0]})"
      end
    end
    #  Get an object value at <code>pos</code>.
    # @overload getValue(name)
    #   @param [String] name the column
    # @return [Object] the value or <code>null</code>
    def get_value(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:getValue, [Java::java.lang.String.java_class]).call(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_value(#{args[0]})"
      end
    end
    #  Get a buffer value at <code>pos</code>.
    # @overload getBuffer(name)
    #   @param [String] name the column
    # @return [::Vertx::Buffer] the value or <code>null</code>
    def get_buffer(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getBuffer, [Java::java.lang.String.java_class]).call(args[0]),::Vertx::Buffer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_buffer(#{args[0]})"
      end
    end
    #  Get a short value at <code>pos</code>.
    # @overload getShort(name)
    #   @param [String] name the column
    # @return [Fixnum] the value or <code>null</code>
    def get_short(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:getShort, [Java::java.lang.String.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_short(#{args[0]})"
      end
    end
    #  Get a double value at <code>pos</code>.
    # @overload getDouble(name)
    #   @param [String] name the column
    # @return [Float] the value or <code>null</code>
    def get_double(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:getDouble, [Java::java.lang.String.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_double(#{args[0]})"
      end
    end
    #  Get a column name at <code>pos</code>.
    # @overload getColumnName(pos)
    #   @param [Fixnum] pos the column position
    # @return [String] the column name or <code>null</code>
    def get_column_name(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getColumnName, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_column_name(#{args[0]})"
      end
    end
    #  Get an integer value at <code>pos</code>.
    # @overload getInteger(name)
    #   @param [String] name the column
    # @return [Fixnum] the value or <code>null</code>
    def get_integer(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:getInteger, [Java::java.lang.String.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_integer(#{args[0]})"
      end
    end
    #  Get a boolean value at <code>pos</code>.
    # @overload getBoolean(name)
    #   @param [String] name the column
    # @return [true,false] the value or <code>null</code>
    def get_boolean?(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:getBoolean, [Java::java.lang.String.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_boolean?(#{args[0]})"
      end
    end
    #  Get a column position for the given column <code>name</code>.
    # @overload getColumnIndex(name)
    #   @param [String] name the column name
    # @return [Fixnum] the column name or <code>-1</code> if not found
    def get_column_index(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:getColumnIndex, [Java::java.lang.String.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_column_index(#{args[0]})"
      end
    end
    #  Get a string value at <code>pos</code>.
    # @overload getString(name)
    #   @param [String] name the column
    # @return [String] the value or <code>null</code>
    def get_string(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:getString, [Java::java.lang.String.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_string(#{args[0]})"
      end
    end
    #  Get a float value at <code>pos</code>.
    # @overload getFloat(name)
    #   @param [String] name the column
    # @return [Float] the value or <code>null</code>
    def get_float(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:getFloat, [Java::java.lang.String.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_float(#{args[0]})"
      end
    end
    #  The JSON null literal value.
    #  <br/>
    #  It is used to distinguish a JSON null literal value from the Java <code>null</code> value. This is only
    #  used when the database supports JSON types.
    def self.JSON_NULL
      ::Vertx::Util::Utils.from_object(Java::IoVertxSqlclient::Row.JSON_NULL)
    end
  end
end
