require 'vertx/buffer'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.Tuple
module VertxSqlClient
  #  A general purpose tuple.
  class Tuple
    # @private
    # @param j_del [::VertxSqlClient::Tuple] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSqlClient::Tuple] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Tuple
    end
    def @@j_api_type.wrap(obj)
      Tuple.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxSqlclient::Tuple.java_class
    end
    #  Get a buffer value at <code>pos</code>.
    # @overload getBuffer(pos)
    #   @param [Fixnum] pos the position
    # @return [::Vertx::Buffer] the value or <code>null</code>
    def get_buffer(*args)
      if args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getBuffer, [Java::int.java_class]).call(args[0]),::Vertx::Buffer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_buffer(#{args[0]})"
      end
    end
    #  Get a short value at <code>pos</code>.
    # @overload getShort(pos)
    #   @param [Fixnum] pos the position
    # @return [Fixnum] the value or <code>null</code>
    def get_short(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getShort, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_short(#{args[0]})"
      end
    end
    # @overload clear()
    # @return [void]
    def clear
      if !block_given?
        return @j_del.java_method(:clear, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling clear()"
      end
    end
    #  Add a float value at the end of the tuple.
    # @overload addFloat(value)
    #   @param [Float] value the value
    # @return [self]
    def add_float(*args)
      if args[0].class == Float && !block_given?
        @j_del.java_method(:addFloat, [Java::JavaLang::Float.java_class]).call(::Vertx::Util::Utils.to_float(args[0]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_float(#{args[0]})"
      end
    end
    #  Get a double value at <code>pos</code>.
    # @overload getDouble(pos)
    #   @param [Fixnum] pos the position
    # @return [Float] the value or <code>null</code>
    def get_double(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getDouble, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_double(#{args[0]})"
      end
    end
    #  Get an integer value at <code>pos</code>.
    # @overload getInteger(pos)
    #   @param [Fixnum] pos the position
    # @return [Fixnum] the value or <code>null</code>
    def get_integer(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getInteger, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_integer(#{args[0]})"
      end
    end
    #  Get a string value at <code>pos</code>.
    # @overload getString(pos)
    #   @param [Fixnum] pos the position
    # @return [String] the value or <code>null</code>
    def get_string(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getString, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_string(#{args[0]})"
      end
    end
    #  Get a float value at <code>pos</code>.
    # @overload getFloat(pos)
    #   @param [Fixnum] pos the position
    # @return [Float] the value or <code>null</code>
    def get_float(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getFloat, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_float(#{args[0]})"
      end
    end
    #  Add an integer value at the end of the tuple.
    # @overload addInteger(value)
    #   @param [Fixnum] value the value
    # @return [self]
    def add_integer(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:addInteger, [Java::JavaLang::Integer.java_class]).call(::Vertx::Util::Utils.to_integer(args[0]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_integer(#{args[0]})"
      end
    end
    #  Get a long value at <code>pos</code>.
    # @overload getLong(pos)
    #   @param [Fixnum] pos the position
    # @return [Fixnum] the value or <code>null</code>
    def get_long(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getLong, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_long(#{args[0]})"
      end
    end
    #  Get an object value at <code>pos</code>.
    # @overload getValue(pos)
    #   @param [Fixnum] pos the position
    # @return [Object] the value or <code>null</code>
    def get_value(*args)
      if args[0].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:getValue, [Java::int.java_class]).call(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_value(#{args[0]})"
      end
    end
    # @overload tuple()
    # @return [::VertxSqlClient::Tuple] a new empty tuple
    def self.tuple
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxSqlclient::Tuple.java_method(:tuple, []).call(),::VertxSqlClient::Tuple)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling tuple()"
      end
    end
    #  Add a buffer value at the end of the tuple.
    # @overload addBuffer(value)
    #   @param [::Vertx::Buffer] value the value
    # @return [self]
    def add_buffer(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:addBuffer, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_buffer(#{args[0]})"
      end
    end
    #  Add a short value at the end of the tuple.
    # @overload addShort(value)
    #   @param [Fixnum] value the value
    # @return [self]
    def add_short(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:addShort, [Java::JavaLang::Short.java_class]).call(::Vertx::Util::Utils.to_short(args[0]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_short(#{args[0]})"
      end
    end
    # @overload size()
    # @return [Fixnum] the tuple size
    def size
      if !block_given?
        return @j_del.java_method(:size, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling size()"
      end
    end
    # @overload get(type,pos)
    #   @param [Nil] type 
    #   @param [Fixnum] pos 
    # @return [Object]
    def get(*args)
      if args[0].class == Class && args[1].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.v_type_of(args[0]).wrap(@j_del.java_method(:get, [Java::JavaLang::Class.java_class,Java::int.java_class]).call(::Vertx::Util::Utils.j_class_of(args[0]),args[1]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get(#{args[0]},#{args[1]})"
      end
    end
    #  Create a tuple of six elements.
    # @overload of(elt1)
    #   @param [Object] elt1 the first value
    # @overload of(elt1,elt2)
    #   @param [Object] elt1 the first value
    #   @param [Object] elt2 the second value
    # @overload of(elt1,elt2,elt3)
    #   @param [Object] elt1 the first value
    #   @param [Object] elt2 the second value
    #   @param [Object] elt3 the third value
    # @overload of(elt1,elt2,elt3,elt4)
    #   @param [Object] elt1 the first value
    #   @param [Object] elt2 the second value
    #   @param [Object] elt3 the third value
    #   @param [Object] elt4 the fourth value
    # @overload of(elt1,elt2,elt3,elt4,elt5)
    #   @param [Object] elt1 the first value
    #   @param [Object] elt2 the second value
    #   @param [Object] elt3 the third value
    #   @param [Object] elt4 the fourth value
    #   @param [Object] elt5 the fifth value
    # @overload of(elt1,elt2,elt3,elt4,elt5,elt6)
    #   @param [Object] elt1 the first value
    #   @param [Object] elt2 the second valueg
    #   @param [Object] elt3 the third value
    #   @param [Object] elt4 the fourth value
    #   @param [Object] elt5 the fifth value
    #   @param [Object] elt6 the sixth value
    # @return [::VertxSqlClient::Tuple] the tuple
    def self.of(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && !block_given? && args[1] == nil && args[2] == nil && args[3] == nil && args[4] == nil && args[5] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxSqlclient::Tuple.java_method(:of, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0])),::VertxSqlClient::Tuple)
      elsif ::Vertx::Util::unknown_type.accept?(args[0]) && ::Vertx::Util::unknown_type.accept?(args[1]) && !block_given? && args[2] == nil && args[3] == nil && args[4] == nil && args[5] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxSqlclient::Tuple.java_method(:of, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),::Vertx::Util::Utils.to_object(args[1])),::VertxSqlClient::Tuple)
      elsif ::Vertx::Util::unknown_type.accept?(args[0]) && ::Vertx::Util::unknown_type.accept?(args[1]) && ::Vertx::Util::unknown_type.accept?(args[2]) && !block_given? && args[3] == nil && args[4] == nil && args[5] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxSqlclient::Tuple.java_method(:of, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),::Vertx::Util::Utils.to_object(args[1]),::Vertx::Util::Utils.to_object(args[2])),::VertxSqlClient::Tuple)
      elsif ::Vertx::Util::unknown_type.accept?(args[0]) && ::Vertx::Util::unknown_type.accept?(args[1]) && ::Vertx::Util::unknown_type.accept?(args[2]) && ::Vertx::Util::unknown_type.accept?(args[3]) && !block_given? && args[4] == nil && args[5] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxSqlclient::Tuple.java_method(:of, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),::Vertx::Util::Utils.to_object(args[1]),::Vertx::Util::Utils.to_object(args[2]),::Vertx::Util::Utils.to_object(args[3])),::VertxSqlClient::Tuple)
      elsif ::Vertx::Util::unknown_type.accept?(args[0]) && ::Vertx::Util::unknown_type.accept?(args[1]) && ::Vertx::Util::unknown_type.accept?(args[2]) && ::Vertx::Util::unknown_type.accept?(args[3]) && ::Vertx::Util::unknown_type.accept?(args[4]) && !block_given? && args[5] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxSqlclient::Tuple.java_method(:of, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),::Vertx::Util::Utils.to_object(args[1]),::Vertx::Util::Utils.to_object(args[2]),::Vertx::Util::Utils.to_object(args[3]),::Vertx::Util::Utils.to_object(args[4])),::VertxSqlClient::Tuple)
      elsif ::Vertx::Util::unknown_type.accept?(args[0]) && ::Vertx::Util::unknown_type.accept?(args[1]) && ::Vertx::Util::unknown_type.accept?(args[2]) && ::Vertx::Util::unknown_type.accept?(args[3]) && ::Vertx::Util::unknown_type.accept?(args[4]) && ::Vertx::Util::unknown_type.accept?(args[5]) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxSqlclient::Tuple.java_method(:of, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),::Vertx::Util::Utils.to_object(args[1]),::Vertx::Util::Utils.to_object(args[2]),::Vertx::Util::Utils.to_object(args[3]),::Vertx::Util::Utils.to_object(args[4]),::Vertx::Util::Utils.to_object(args[5])),::VertxSqlClient::Tuple)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling of(#{args[0]},#{args[1]},#{args[2]},#{args[3]},#{args[4]},#{args[5]})"
      end
    end
    #  Get a boolean value at <code>pos</code>.
    # @overload getBoolean(pos)
    #   @param [Fixnum] pos the position
    # @return [true,false] the value or <code>null</code>
    def get_boolean?(*args)
      if args[0].class == Fixnum && !block_given?
        return @j_del.java_method(:getBoolean, [Java::int.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_boolean?(#{args[0]})"
      end
    end
    #  Add a long value at the end of the tuple.
    # @overload addLong(value)
    #   @param [Fixnum] value the value
    # @return [self]
    def add_long(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:addLong, [Java::JavaLang::Long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_long(#{args[0]})"
      end
    end
    #  Add a double value at the end of the tuple.
    # @overload addDouble(value)
    #   @param [Float] value the value
    # @return [self]
    def add_double(*args)
      if args[0].class == Float && !block_given?
        @j_del.java_method(:addDouble, [Java::JavaLang::Double.java_class]).call(::Vertx::Util::Utils.to_double(args[0]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_double(#{args[0]})"
      end
    end
    #  Add a string value at the end of the tuple.
    # @overload addString(value)
    #   @param [String] value the value
    # @return [self]
    def add_string(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:addString, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_string(#{args[0]})"
      end
    end
    #  Add an object value at the end of the tuple.
    # @overload addValue(value)
    #   @param [Object] value the value
    # @return [self]
    def add_value(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && !block_given?
        @j_del.java_method(:addValue, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_value(#{args[0]})"
      end
    end
    #  Add a boolean value at the end of the tuple.
    # @overload addBoolean(value)
    #   @param [true,false] value the value
    # @return [self]
    def add_boolean(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:addBoolean, [Java::JavaLang::Boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_boolean(#{args[0]})"
      end
    end
    #  The JSON null literal value.
    #  <br/>
    #  It is used to distinguish a JSON null literal value from the Java <code>null</code> value. This is only
    #  used when the database supports JSON types.
    def self.JSON_NULL
      ::Vertx::Util::Utils.from_object(Java::IoVertxSqlclient::Tuple.JSON_NULL)
    end
  end
end
