require 'vertx-stomp/stomp_server_connection'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.stomp.Frames
module VertxStomp
  #  Utility methods to build common {Hash{String => Object}}s. It defines a non-STOMP frame (<code>PING</code>) that is used for
  #  heartbeats. When such frame is written on the wire it is just the <code>0</code> byte.
  #  <p/>
  #  This class is thread-safe.
  class Frames
    # @private
    # @param j_del [::VertxStomp::Frames] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxStomp::Frames] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Frames
    end
    def @@j_api_type.wrap(obj)
      Frames.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtStomp::Frames.java_class
    end
    # @overload createErrorFrame(message,headers,body)
    #   @param [String] message 
    #   @param [Hash{String => String}] headers 
    #   @param [String] body 
    # @return [Hash{String => Object}]
    def self.create_error_frame(*args)
      if args[0].class == String && args[1].class == Hash && args[2].class == String && !block_given?
        return Java::IoVertxExtStomp::Frames.java_method(:createErrorFrame, [Java::java.lang.String.java_class,Java::JavaUtil::Map.java_class,Java::java.lang.String.java_class]).call(args[0],Hash[args[1].map { |k,v| [k,v] }],args[2]) != nil ? JSON.parse(Java::IoVertxExtStomp::Frames.java_method(:createErrorFrame, [Java::java.lang.String.java_class,Java::JavaUtil::Map.java_class,Java::java.lang.String.java_class]).call(args[0],Hash[args[1].map { |k,v| [k,v] }],args[2]).toJson.encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_error_frame(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    # @overload ping()
    # @return [Hash{String => Object}]
    def self.ping
      if !block_given?
        return Java::IoVertxExtStomp::Frames.java_method(:ping, []).call() != nil ? JSON.parse(Java::IoVertxExtStomp::Frames.java_method(:ping, []).call().toJson.encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling ping()"
      end
    end
    # @overload createReceiptFrame(receiptId,headers)
    #   @param [String] receiptId 
    #   @param [Hash{String => String}] headers 
    # @return [Hash{String => Object}]
    def self.create_receipt_frame(*args)
      if args[0].class == String && args[1].class == Hash && !block_given?
        return Java::IoVertxExtStomp::Frames.java_method(:createReceiptFrame, [Java::java.lang.String.java_class,Java::JavaUtil::Map.java_class]).call(args[0],Hash[args[1].map { |k,v| [k,v] }]) != nil ? JSON.parse(Java::IoVertxExtStomp::Frames.java_method(:createReceiptFrame, [Java::java.lang.String.java_class,Java::JavaUtil::Map.java_class]).call(args[0],Hash[args[1].map { |k,v| [k,v] }]).toJson.encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_receipt_frame(#{args[0]},#{args[1]})"
      end
    end
    # @overload handleReceipt(frame,connection)
    #   @param [Hash{String => Object}] frame 
    #   @param [::VertxStomp::StompServerConnection] connection 
    # @return [void]
    def self.handle_receipt(*args)
      if args[0].class == Hash && args[1].class.method_defined?(:j_del) && !block_given?
        return Java::IoVertxExtStomp::Frames.java_method(:handleReceipt, [Java::IoVertxExtStomp::Frame.java_class,Java::IoVertxExtStomp::StompServerConnection.java_class]).call(Java::IoVertxExtStomp::Frame.new(::Vertx::Util::Utils.to_json_object(args[0])),args[1].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle_receipt(#{args[0]},#{args[1]})"
      end
    end
    def self.PING
      Java::IoVertxExtStomp::Frames.PING != nil ? JSON.parse(Java::IoVertxExtStomp::Frames.PING.toJson.encode) : nil
    end
  end
end
