require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.multipart.FormDataPart
module VertxWebCommon
  #  A form data part of a {::VertxWebCommon::MultipartForm}.
  class FormDataPart
    # @private
    # @param j_del [::VertxWebCommon::FormDataPart] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebCommon::FormDataPart] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == FormDataPart
    end
    def @@j_api_type.wrap(obj)
      FormDataPart.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebMultipart::FormDataPart.java_class
    end
    # @overload filename()
    # @return [String] the filename when this part is a file upload otherwise <code>null</code>
    def filename
      if !block_given?
        if @cached_filename != nil
          return @cached_filename
        end
        return @cached_filename = @j_del.java_method(:filename, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling filename()"
      end
    end
    # @overload isAttribute()
    # @return [true,false] <code>true</code> when this part is an attribute
    def attribute?
      if !block_given?
        if @cached_is_attribute != nil
          return @cached_is_attribute
        end
        return @cached_is_attribute = @j_del.java_method(:isAttribute, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling attribute?()"
      end
    end
    # @overload name()
    # @return [String] the name
    def name
      if !block_given?
        if @cached_name != nil
          return @cached_name
        end
        return @cached_name = @j_del.java_method(:name, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling name()"
      end
    end
    # @overload mediaType()
    # @return [String] the media type when this part is a file upload otherwise <code>null</code>
    def media_type
      if !block_given?
        if @cached_media_type != nil
          return @cached_media_type
        end
        return @cached_media_type = @j_del.java_method(:mediaType, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling media_type()"
      end
    end
    # @overload isFileUpload()
    # @return [true,false] <code>true</code> when this part is a file upload
    def file_upload?
      if !block_given?
        if @cached_is_file_upload != nil
          return @cached_is_file_upload
        end
        return @cached_is_file_upload = @j_del.java_method(:isFileUpload, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling file_upload?()"
      end
    end
    # @overload value()
    # @return [String] the value when the part for a form attribute otherwise <code>null</code>
    def value
      if !block_given?
        if @cached_value != nil
          return @cached_value
        end
        return @cached_value = @j_del.java_method(:value, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling value()"
      end
    end
    # @overload isText()
    # @return [true,false] whether the file upload is text or binary when this part is a file upload otherwise <code>null</code>
    def text?
      if !block_given?
        if @cached_is_text != nil
          return @cached_is_text
        end
        return @cached_is_text = @j_del.java_method(:isText, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling text?()"
      end
    end
    # @overload pathname()
    # @return [String] the pathname when this part is a file upload otherwise <code>null</code>
    def pathname
      if !block_given?
        if @cached_pathname != nil
          return @cached_pathname
        end
        return @cached_pathname = @j_del.java_method(:pathname, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pathname()"
      end
    end
  end
end
