require 'vertx-web/session_store'
require 'vertx-web/routing_context'
require 'vertx-auth-common/auth_provider'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.SessionHandler
module VertxWeb
  #  A handler that maintains a {::VertxWeb::Session} for each browser
  #  session.
  #  <p>
  #  It looks up the session for each request based on a session cookie which
  #  contains a session ID. It stores the session when the response is ended in
  #  the session store.
  #  <p>
  #  The session is available on the routing context with
  #  .
  class SessionHandler
    # @private
    # @param j_del [::VertxWeb::SessionHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::SessionHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == SessionHandler
    end
    def @@j_api_type.wrap(obj)
      SessionHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandler::SessionHandler.java_class
    end
    #  Sets whether the 'HttpOnly' flag should be set for the session cookie. When
    #  set this flag instructs browsers to prevent Javascript access to the the
    #  cookie. Used as a line of defence against the most common XSS attacks.
    # @overload setCookieHttpOnlyFlag(httpOnly)
    #   @param [true,false] httpOnly true to set the HttpOnly flag on the cookie
    # @return [self]
    def set_cookie_http_only_flag(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:setCookieHttpOnlyFlag, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_cookie_http_only_flag(#{args[0]})"
      end
    end
    #  Set the session timeout
    # @overload setSessionTimeout(timeout)
    #   @param [Fixnum] timeout the timeout, in ms.
    # @return [self]
    def set_session_timeout(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:setSessionTimeout, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_session_timeout(#{args[0]})"
      end
    end
    #  Sets whether the 'secure' flag should be set for the session cookie. When set
    #  this flag instructs browsers to only send the cookie over HTTPS. Note that
    #  this will probably stop your sessions working if used without HTTPS (e.g. in
    #  development).
    # @overload setCookieSecureFlag(secure)
    #   @param [true,false] secure true to set the secure flag on the cookie
    # @return [self]
    def set_cookie_secure_flag(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:setCookieSecureFlag, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_cookie_secure_flag(#{args[0]})"
      end
    end
    #  Set expected session id minimum length.
    # @overload setMinLength(minLength)
    #   @param [Fixnum] minLength the session id minimal length
    # @return [self]
    def set_min_length(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:setMinLength, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_min_length(#{args[0]})"
      end
    end
    #  Set the session cookie name
    # @overload setSessionCookieName(sessionCookieName)
    #   @param [String] sessionCookieName the session cookie name
    # @return [self]
    def set_session_cookie_name(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setSessionCookieName, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_session_cookie_name(#{args[0]})"
      end
    end
    #  Set an auth provider that will allow retrieving the User object from the session to the current routing context.
    # @overload setAuthProvider(authProvider)
    #   @param [::VertxAuthCommon::AuthProvider] authProvider any auth provider.
    # @return [self]
    def set_auth_provider(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:setAuthProvider, [Java::IoVertxExtAuth::AuthProvider.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_auth_provider(#{args[0]})"
      end
    end
    #  Set the session cookie path
    # @overload setSessionCookiePath(sessionCookiePath)
    #   @param [String] sessionCookiePath the session cookie path
    # @return [self]
    def set_session_cookie_path(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setSessionCookiePath, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_session_cookie_path(#{args[0]})"
      end
    end
    #  Set whether a nagging log warning should be written if the session handler is
    #  accessed over HTTP, not HTTPS
    # @overload setNagHttps(nag)
    #   @param [true,false] nag true to nag
    # @return [self]
    def set_nag_https(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:setNagHttps, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_nag_https(#{args[0]})"
      end
    end
    #  Create a session handler
    # @overload create(sessionStore)
    #   @param [::VertxWeb::SessionStore] sessionStore the session store
    # @return [::VertxWeb::SessionHandler] the handler
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::SessionHandler.java_method(:create, [Java::IoVertxExtWebSstore::SessionStore.java_class]).call(args[0].j_del),::VertxWeb::SessionHandler)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    #  Something has happened, so handle it.
    # @overload handle(event)
    #   @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle(#{args[0]})"
      end
    end
    #  Default name of session cookie
    def self.DEFAULT_SESSION_COOKIE_NAME
      Java::IoVertxExtWebHandler::SessionHandler.DEFAULT_SESSION_COOKIE_NAME
    end
    #  Default path of session cookie
    def self.DEFAULT_SESSION_COOKIE_PATH
      Java::IoVertxExtWebHandler::SessionHandler.DEFAULT_SESSION_COOKIE_PATH
    end
    #  Default time, in ms, that a session lasts for without being accessed before
    #  expiring.
    def self.DEFAULT_SESSION_TIMEOUT
      Java::IoVertxExtWebHandler::SessionHandler.DEFAULT_SESSION_TIMEOUT
    end
    #  Default of whether a nagging log warning should be written if the session
    #  handler is accessed over HTTP, not HTTPS
    def self.DEFAULT_NAG_HTTPS
      Java::IoVertxExtWebHandler::SessionHandler.DEFAULT_NAG_HTTPS
    end
    #  Default of whether the cookie has the HttpOnly flag set More info:
    #  https://www.owasp.org/index.php/HttpOnly
    def self.DEFAULT_COOKIE_HTTP_ONLY_FLAG
      Java::IoVertxExtWebHandler::SessionHandler.DEFAULT_COOKIE_HTTP_ONLY_FLAG
    end
    #  Default of whether the cookie has the 'secure' flag set to allow transmission
    #  over https only. More info: https://www.owasp.org/index.php/SecureFlag
    def self.DEFAULT_COOKIE_SECURE_FLAG
      Java::IoVertxExtWebHandler::SessionHandler.DEFAULT_COOKIE_SECURE_FLAG
    end
    #  Default min length for a session id. More info:
    #  https://www.owasp.org/index.php/Session_Management_Cheat_Sheet
    def self.DEFAULT_SESSIONID_MIN_LENGTH
      Java::IoVertxExtWebHandler::SessionHandler.DEFAULT_SESSIONID_MIN_LENGTH
    end
  end
end
