require 'vertx-web/session'
require 'vertx/vertx'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.sstore.SessionStore
module VertxWeb
  #  A session store is used to store sessions for an Vert.x-Web web app
  class SessionStore
    # @private
    # @param j_del [::VertxWeb::SessionStore] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::SessionStore] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == SessionStore
    end
    def @@j_api_type.wrap(obj)
      SessionStore.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebSstore::SessionStore.java_class
    end
    #  Initialize this store.
    # @overload init(vertx,options)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [Hash{String => Object}] options optional Json with extra configuration options
    # @return [self]
    def init(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        @j_del.java_method(:init, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1]))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling init(#{args[0]},#{args[1]})"
      end
    end
    #  Get the number of sessions in the store.
    #  <p>
    #  Beware of the result which is just an estimate, in particular with distributed session stores.
    # @overload size(resultHandler)
    #   @yield will be called with the number, or a failure
    # @return [void]
    def size
      if true
        if (block_given?)
          return @j_del.java_method(:size, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:size, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling size()"
      end
    end
    #  The retry timeout value in milli seconds used by the session handler when it retrieves a value from the store.<p/>
    # 
    #  A non positive value means there is no retry at all.
    # @overload retryTimeout()
    # @return [Fixnum] the timeout value, in ms
    def retry_timeout
      if !block_given?
        return @j_del.java_method(:retryTimeout, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling retry_timeout()"
      end
    end
    #  Get the session with the specified ID.
    # @overload get(cookieValue,resultHandler)
    #   @param [String] cookieValue the unique ID of the session
    #   @yield will be called with a result holding the session, or a failure
    # @return [void]
    def get(*args)
      if args[0].class == String && true
        if (block_given?)
          return @j_del.java_method(:get, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWeb::Session) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:get, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxWeb::Session) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxWeb::Session.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get(#{args[0]})"
      end
    end
    #  Remove all sessions from the store.
    # @overload clear(resultHandler)
    #   @yield will be called with a success or a failure
    # @return [void]
    def clear
      if true
        if (block_given?)
          return @j_del.java_method(:clear, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:clear, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling clear()"
      end
    end
    #  Create a Session store given a backend and configuration JSON.
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx vertx instance
    # @overload create(vertx,options)
    #   @param [::Vertx::Vertx] vertx vertx instance
    #   @param [Hash{String => Object}] options extra options for initialization
    # @return [::VertxWeb::SessionStore] the store or runtime exception
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebSstore::SessionStore.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxWeb::SessionStore)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebSstore::SessionStore.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(args[0].j_del,::Vertx::Util::Utils.to_json_object(args[1])),::VertxWeb::SessionStore)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Close the store
    # @overload close()
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Delete the session with the specified ID.
    # @overload delete(id,resultHandler)
    #   @param [String] id the session id
    #   @yield will be called with a success or a failure
    # @return [void]
    def delete(*args)
      if args[0].class == String && true
        if (block_given?)
          return @j_del.java_method(:delete, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:delete, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delete(#{args[0]})"
      end
    end
    #  Create a new session.
    # @overload createSession(timeout)
    #   @param [Fixnum] timeout - the session timeout, in ms
    # @overload createSession(timeout,length)
    #   @param [Fixnum] timeout - the session timeout, in ms
    #   @param [Fixnum] length - the required length for the session id
    # @return [::VertxWeb::Session] the session
    def create_session(*args)
      if args[0].class == Fixnum && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createSession, [Java::long.java_class]).call(args[0]),::VertxWeb::Session)
      elsif args[0].class == Fixnum && args[1].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createSession, [Java::long.java_class,Java::int.java_class]).call(args[0],args[1]),::VertxWeb::Session)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_session(#{args[0]},#{args[1]})"
      end
    end
    #  Add a session with the specified ID.
    # @overload put(session,resultHandler)
    #   @param [::VertxWeb::Session] session the session
    #   @yield will be called with a success or a failure
    # @return [void]
    def put(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:put, [Java::IoVertxExtWeb::Session.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:put, [Java::IoVertxExtWeb::Session.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put(#{args[0]})"
      end
    end
    #  Default length for a session id.
    #  More info: https://www.owasp.org/index.php/Session_Management_Cheat_Sheet
    def self.DEFAULT_SESSIONID_LENGTH
      Java::IoVertxExtWebSstore::SessionStore.DEFAULT_SESSIONID_LENGTH
    end
  end
end
