require 'vertx-web/routing_context'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.TimeoutHandler
module VertxWeb
  #  Handler that will timeout requests if the response has not been written after a certain time.
  #  Timeout requests will be ended with an HTTP status code `503`.
  class TimeoutHandler
    # @private
    # @param j_del [::VertxWeb::TimeoutHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::TimeoutHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == TimeoutHandler
    end
    def @@j_api_type.wrap(obj)
      TimeoutHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandler::TimeoutHandler.java_class
    end
    #  Create a handler
    # @overload create()
    # @overload create(timeout)
    #   @param [Fixnum] timeout the timeout, in ms
    # @overload create(timeout,errorCode)
    #   @param [Fixnum] timeout the timeout, in ms
    #   @param [Fixnum] errorCode 
    # @return [::VertxWeb::TimeoutHandler] the handler
    def self.create(*args)
      if !block_given? && args[0] == nil && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::TimeoutHandler.java_method(:create, []).call(),::VertxWeb::TimeoutHandler)
      elsif args[0].class == Fixnum && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::TimeoutHandler.java_method(:create, [Java::long.java_class]).call(args[0]),::VertxWeb::TimeoutHandler)
      elsif args[0].class == Fixnum && args[1].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::TimeoutHandler.java_method(:create, [Java::long.java_class,Java::int.java_class]).call(args[0],args[1]),::VertxWeb::TimeoutHandler)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Something has happened, so handle it.
    # @overload handle(event)
    #   @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle(#{args[0]})"
      end
    end
    #  The default timeout, in ms
    def self.DEFAULT_TIMEOUT
      Java::IoVertxExtWebHandler::TimeoutHandler.DEFAULT_TIMEOUT
    end
    #  The default error code
    def self.DEFAULT_ERRORCODE
      Java::IoVertxExtWebHandler::TimeoutHandler.DEFAULT_ERRORCODE
    end
  end
end
