require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.http.Cookie
module Vertx
  #  Represents an HTTP Cookie.
  #  <p>
  #  All cookies must have a name and a value and can optionally have other fields set such as path, domain, etc.
  class Cookie
    # @private
    # @param j_del [::Vertx::Cookie] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::Cookie] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Cookie
    end
    def @@j_api_type.wrap(obj)
      Cookie.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreHttp::Cookie.java_class
    end
    #  Encode the cookie to a string. This is what is used in the Set-Cookie header
    # @overload encode()
    # @return [String] the encoded cookie
    def encode
      if !block_given?
        return @j_del.java_method(:encode, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling encode()"
      end
    end
    # @overload getDomain()
    # @return [String] the domain for the cookie
    def get_domain
      if !block_given?
        return @j_del.java_method(:getDomain, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_domain()"
      end
    end
    # @overload getValue()
    # @return [String] the value of this cookie
    def get_value
      if !block_given?
        return @j_del.java_method(:getValue, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_value()"
      end
    end
    # @overload getName()
    # @return [String] the name of this cookie
    def get_name
      if !block_given?
        return @j_del.java_method(:getName, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_name()"
      end
    end
    #  Create a new cookie
    # @overload cookie(name,value)
    #   @param [String] name the name of the cookie
    #   @param [String] value the cookie value
    # @return [::Vertx::Cookie] the cookie
    def self.cookie(*args)
      if args[0].class == String && args[1].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreHttp::Cookie.java_method(:cookie, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]),::Vertx::Cookie)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling cookie(#{args[0]},#{args[1]})"
      end
    end
    #  Sets the maximum age of this cookie in seconds.
    #  If an age of <code>0</code> is specified, this cookie will be
    #  automatically removed by browser because it will expire immediately.
    #  If MIN_VALUE is specified, this cookie will be removed when the
    #  browser is closed.
    #  If you don't set this the cookie will be a session cookie and be removed when the browser is closed.
    # @overload setMaxAge(maxAge)
    #   @param [Fixnum] maxAge The maximum age of this cookie in seconds
    # @return [self]
    def set_max_age(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:setMaxAge, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_max_age(#{args[0]})"
      end
    end
    #  Sets the domain of this cookie
    # @overload setDomain(domain)
    #   @param [String] domain The domain to use
    # @return [self]
    def set_domain(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setDomain, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_domain(#{args[0]})"
      end
    end
    #  Determines if this cookie is HTTP only.
    #  If set to true, this cookie cannot be accessed by a client
    #  side script. However, this works only if the browser supports it.
    #  For for information, please look
    #  <a href="http://www.owasp.org/index.php/HTTPOnly">here</a>.
    # @overload setHttpOnly(httpOnly)
    #   @param [true,false] httpOnly True if the cookie is HTTP only, otherwise false.
    # @return [self]
    def set_http_only(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:setHttpOnly, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_http_only(#{args[0]})"
      end
    end
    #  Sets the value of this cookie
    # @overload setValue(value)
    #   @param [String] value The value to set
    # @return [self]
    def set_value(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setValue, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_value(#{args[0]})"
      end
    end
    # @overload getPath()
    # @return [String] the path for this cookie
    def get_path
      if !block_given?
        return @j_del.java_method(:getPath, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_path()"
      end
    end
    #  Sets the path of this cookie.
    # @overload setPath(path)
    #   @param [String] path The path to use for this cookie
    # @return [self]
    def set_path(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:setPath, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_path(#{args[0]})"
      end
    end
    #  Sets the security getStatus of this cookie
    # @overload setSecure(secure)
    #   @param [true,false] secure True if this cookie is to be secure, otherwise false
    # @return [self]
    def set_secure(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:setSecure, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_secure(#{args[0]})"
      end
    end
  end
end
