require 'vertx/mx_record'
require 'vertx/future'
require 'vertx/srv_record'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.dns.DnsClient
module Vertx
  #  Provides a way to asynchronously lookup information from DNS servers.
  #  <p>
  #  Please consult the documentation for more information on DNS clients.
  class DnsClient
    # @private
    # @param j_del [::Vertx::DnsClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::DnsClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == DnsClient
    end
    def @@j_api_type.wrap(obj)
      DnsClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreDns::DnsClient.java_class
    end
    #  Try to resolve all AAAA (ipv6) records for the given name.
    # @overload resolveAAAA(name,handler)
    #   @param [String] name the name to resolve
    #   @yield the {Proc} to notify with the {AsyncResult}. The handler will get notified with a List that contains all the resolved Inet6Addresses. If none was found an empty List will be used. If an error accours it will get failed.
    # @return [self]
    def resolve_aaaa(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:resolveAAAA, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:resolveAAAA, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resolve_aaaa(#{args[0]})"
      end
    end
    #  Try to lookup the A (ipv4) or AAAA (ipv6) record for the given name. The first found will be used.
    # @overload lookup(name,handler)
    #   @param [String] name the name to resolve
    #   @yield the {Proc} to notify with the {AsyncResult}. The handler will get notified with the resolved address if a record was found. If non was found it will get notifed with <code>null</code>. If an error accours it will get failed.
    # @return [self]
    def lookup(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:lookup, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:lookup, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling lookup(#{args[0]})"
      end
    end
    #  Try to resolve all A (ipv4) records for the given name.
    # @overload resolveA(name,handler)
    #   @param [String] name the name to resolve
    #   @yield the {Proc} to notify with the {AsyncResult}. The handler will get notified with a List that contains all the resolved Inet4Addresses. If none was found an empty List will be used. If an error accours it will get failed.
    # @return [self]
    def resolve_a(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:resolveA, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:resolveA, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resolve_a(#{args[0]})"
      end
    end
    #  Try to resolve the SRV records for the given name.
    # @overload resolveSRV(name,handler)
    #   @param [String] name the name for which the SRV records should be resolved
    #   @yield the  to notify with the . The handler will get notified with a List that contains all resolved {::Vertx::SrvRecord}s. If none was found it will get notified with an empty List. If an error accours it will get failed.
    # @return [self]
    def resolve_srv(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:resolveSRV, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::Vertx::SrvRecord) } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:resolveSRV, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::Vertx::SrvRecord) } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resolve_srv(#{args[0]})"
      end
    end
    #  Try to lookup the A (ipv4) record for the given name. The first found will be used.
    # @overload lookup4(name,handler)
    #   @param [String] name the name to resolve
    #   @yield the  to notify with the {AsyncResult}. The handler will get notified with the resolved Inet4Address if a record was found. If non was found it will get notifed with <code>null</code>. If an error accours it will get failed.
    # @return [self]
    def lookup4(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:lookup4, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:lookup4, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling lookup4(#{args[0]})"
      end
    end
    #  Try to do a reverse lookup of an IP address. This is basically the same as doing trying to resolve a PTR record
    #  but allows you to just pass in the IP address and not a valid ptr query string.
    # @overload reverseLookup(ipaddress,handler)
    #   @param [String] ipaddress the IP address to resolve the PTR for
    #   @yield the  to notify with the . The handler will get notified with the resolved String if a record was found. If none was found it will get notified with <code>null</code>. If an error accours it will get failed.
    # @return [self]
    def reverse_lookup(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:reverseLookup, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:reverseLookup, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling reverse_lookup(#{args[0]})"
      end
    end
    #  Try to lookup the AAAA (ipv6) record for the given name. The first found will be used.
    # @overload lookup6(name,handler)
    #   @param [String] name the name to resolve
    #   @yield the  to notify with the . The handler will get notified with the resolved Inet6Address if a record was found. If non was found it will get notifed with <code>null</code>. If an error accours it will get failed.
    # @return [self]
    def lookup6(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:lookup6, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:lookup6, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling lookup6(#{args[0]})"
      end
    end
    #  Try to resolve the MX records for the given name.
    # @overload resolveMX(name,handler)
    #   @param [String] name the name for which the MX records should be resolved
    #   @yield the {Proc} to notify with the {AsyncResult}. The handler will get notified with a List that contains all resolved {::Vertx::MxRecord}s, sorted by their {::Vertx::MxRecord#priority}. If non was found it will get notified with an empty List. If an error accours it will get failed.
    # @return [self]
    def resolve_mx(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:resolveMX, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::Vertx::MxRecord) } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:resolveMX, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::Vertx::MxRecord) } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resolve_mx(#{args[0]})"
      end
    end
    #  Try to resolve the PTR record for the given name.
    # @overload resolvePTR(name,handler)
    #   @param [String] name the name to resolve the PTR for
    #   @yield the  to notify with the . The handler will get notified with the resolved String if a record was found. If none was found it will get notified with <code>null</code>. If an error accours it will get failed.
    # @return [self]
    def resolve_ptr(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:resolvePTR, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:resolvePTR, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resolve_ptr(#{args[0]})"
      end
    end
    #  Try to resolve the TXT records for the given name.
    # @overload resolveTXT(name,handler)
    #   @param [String] name the name for which the TXT records should be resolved
    #   @yield the  to notify with the . The handler will get notified with a List that contains all resolved Strings. If none was found it will get notified with an empty List. If an error accours it will get failed.
    # @return [self]
    def resolve_txt(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:resolveTXT, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:resolveTXT, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resolve_txt(#{args[0]})"
      end
    end
    #  Try to resolve the NS records for the given name.
    # @overload resolveNS(name,handler)
    #   @param [String] name the name for which the NS records should be resolved
    #   @yield the  to notify with the . The handler will get notified with a List that contains all resolved Strings. If none was found it will get notified with an empty List. If an error accours it will get failed.
    # @return [self]
    def resolve_ns(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:resolveNS, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:resolveNS, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resolve_ns(#{args[0]})"
      end
    end
    #  Try to resolve the CNAME record for the given name.
    # @overload resolveCNAME(name,handler)
    #   @param [String] name the name to resolve the CNAME for
    #   @yield the  to notify with the . The handler will get notified with the resolved String if a record was found. If none was found it will get notified with <code>null</code>. If an error accours it will get failed.
    # @return [self]
    def resolve_cname(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:resolveCNAME, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:resolveCNAME, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resolve_cname(#{args[0]})"
      end
    end
  end
end
