require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.shareddata.LocalMap
module Vertx
  #  Local maps can be used to share data safely in a single Vert.x instance.
  #  <p>
  #  By default the map allows immutable keys and values.
  #  Custom keys and values should implement {Nil} interface. The map returns their copies.
  #  <p>
  #  This ensures there is no shared access to mutable state from different threads (e.g. different event loops) in the
  #  Vert.x instance, and means you don't have to protect access to that state using synchronization or locks.
  #  <p>
  # 
  #  Since the version 3.4, this class extends the  interface. However some methods are only accessible in Java.
  class LocalMap
    # @private
    # @param j_del [::Vertx::LocalMap] the java delegate
    def initialize(j_del, j_arg_K=nil, j_arg_V=nil)
      @j_del = j_del
      @j_arg_K = j_arg_K != nil ? j_arg_K : ::Vertx::Util::unknown_type
      @j_arg_V = j_arg_V != nil ? j_arg_V : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::Vertx::LocalMap] the underlying java delegate
    def j_del
      @j_del
    end
    #  Replace the entry only if there is an existing entry with the specified key and value.
    #  <p>
    #  This method is the polyglot version of {::Vertx::LocalMap#replace}.
    # @overload replaceIfPresent(key,oldValue,newValue)
    #   @param [Object] key the key
    #   @param [Object] oldValue the old value
    #   @param [Object] newValue the new value
    # @return [true,false] true if removed
    def replace_if_present?(*args)
      if @j_arg_K.accept?(args[0]) && @j_arg_V.accept?(args[1]) && @j_arg_V.accept?(args[2]) && !block_given?
        return @j_del.java_method(:replaceIfPresent, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(@j_arg_K.unwrap(args[0]),@j_arg_V.unwrap(args[1]),@j_arg_V.unwrap(args[2]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling replace_if_present?(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Returns the value to which the specified key is mapped, or
    #  <code>defaultValue</code> if this map contains no mapping for the key.
    # @overload getOrDefault(key,defaultValue)
    #   @param [Object] key the key whose associated value is to be returned
    #   @param [Object] defaultValue the default mapping of the key
    # @return [Object] the value to which the specified key is mapped, or <code>defaultValue</code> if this map contains no mapping for the key
    def get_or_default(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && @j_arg_V.accept?(args[1]) && !block_given?
        return @j_arg_V.wrap(@j_del.java_method(:getOrDefault, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),@j_arg_V.unwrap(args[1])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_or_default(#{args[0]},#{args[1]})"
      end
    end
    #  Returns <code>true</code> if this map contains a mapping for the specified
    #  key.
    # @overload containsKey(key)
    #   @param [Object] key key whose presence in this map is to be tested
    # @return [true,false] <code>true</code> if this map contains a mapping for the specified key
    def contains_key?(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && !block_given?
        return @j_del.java_method(:containsKey, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling contains_key?(#{args[0]})"
      end
    end
    #  Replace the entry only if there is an existing entry with the key
    # @overload replace(key,value)
    #   @param [Object] key the key
    #   @param [Object] value the new value
    # @return [Object] the old value
    def replace(*args)
      if @j_arg_K.accept?(args[0]) && @j_arg_V.accept?(args[1]) && !block_given?
        return @j_arg_V.wrap(@j_del.java_method(:replace, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(@j_arg_K.unwrap(args[0]),@j_arg_V.unwrap(args[1])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling replace(#{args[0]},#{args[1]})"
      end
    end
    # @overload isEmpty()
    # @return [true,false] true if there are zero entries in the map
    def empty?
      if !block_given?
        return @j_del.java_method(:isEmpty, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling empty?()"
      end
    end
    #  Clear all entries in the map
    # @overload clear()
    # @return [void]
    def clear
      if !block_given?
        return @j_del.java_method(:clear, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling clear()"
      end
    end
    #  Returns @{code true} if this map maps one or more keys to the
    #  specified value.
    # @overload containsValue(value)
    #   @param [Object] value value whose presence in this map is to be tested
    # @return [true,false] @{code true} if this map maps one or more keys to the specified value
    def contains_value?(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && !block_given?
        return @j_del.java_method(:containsValue, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling contains_value?(#{args[0]})"
      end
    end
    #  Remove an entry from the map
    # @overload remove(key)
    #   @param [Object] key the key
    # @return [Object] the old value
    def remove(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && !block_given?
        return @j_arg_V.wrap(@j_del.java_method(:remove, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove(#{args[0]})"
      end
    end
    #  Put an entry in the map
    # @overload put(key,value)
    #   @param [Object] key the key
    #   @param [Object] value the value
    # @return [Object] return the old value, or null if none
    def put(*args)
      if @j_arg_K.accept?(args[0]) && @j_arg_V.accept?(args[1]) && !block_given?
        return @j_arg_V.wrap(@j_del.java_method(:put, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(@j_arg_K.unwrap(args[0]),@j_arg_V.unwrap(args[1])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put(#{args[0]},#{args[1]})"
      end
    end
    #  Get the size of the map
    # @overload size()
    # @return [Fixnum] the number of entries in the map
    def size
      if !block_given?
        return @j_del.java_method(:size, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling size()"
      end
    end
    #  Get a value from the map
    # @overload get(key)
    #   @param [Object] key the key
    # @return [Object] the value, or null if none
    def get(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && !block_given?
        return @j_arg_V.wrap(@j_del.java_method(:get, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get(#{args[0]})"
      end
    end
    #  Close and release the map
    # @overload close()
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Put the entry only if there is no existing entry for that key
    # @overload putIfAbsent(key,value)
    #   @param [Object] key the key
    #   @param [Object] value the value
    # @return [Object] the old value or null, if none
    def put_if_absent(*args)
      if @j_arg_K.accept?(args[0]) && @j_arg_V.accept?(args[1]) && !block_given?
        return @j_arg_V.wrap(@j_del.java_method(:putIfAbsent, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(@j_arg_K.unwrap(args[0]),@j_arg_V.unwrap(args[1])))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling put_if_absent(#{args[0]},#{args[1]})"
      end
    end
    #  Remove the entry only if there is an entry with the specified key and value.
    #  <p>
    #  This method is the poyglot version of {::Vertx::LocalMap#remove}.
    # @overload removeIfPresent(key,value)
    #   @param [Object] key the key
    #   @param [Object] value the value
    # @return [true,false] true if removed
    def remove_if_present?(*args)
      if @j_arg_K.accept?(args[0]) && @j_arg_V.accept?(args[1]) && !block_given?
        return @j_del.java_method(:removeIfPresent, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(@j_arg_K.unwrap(args[0]),@j_arg_V.unwrap(args[1]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove_if_present?(#{args[0]},#{args[1]})"
      end
    end
  end
end
