require 'vertx/promise'
require 'vertx/vertx'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.circuitbreaker.CircuitBreaker
module VertxCircuitBreaker
  #  An implementation of the circuit breaker pattern for Vert.x
  class CircuitBreaker
    # @private
    # @param j_del [::VertxCircuitBreaker::CircuitBreaker] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxCircuitBreaker::CircuitBreaker] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == CircuitBreaker
    end
    def @@j_api_type.wrap(obj)
      CircuitBreaker.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCircuitbreaker::CircuitBreaker.java_class
    end
    # @overload retryPolicy(retryPolicy)
    #   @yield 
    # @return [self]
    def retry_policy(*args)
      if block_given? && args[0] == nil
        @j_del.java_method(:retryPolicy, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(event) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling retry_policy(#{args[0]})"
      end
    end
    #  Executes the given operation with the circuit breaker control. The operation is generally calling an
    #  <em>external</em> system. The operation receives a  object as parameter and <strong>must</strong>
    #  call  when the operation has terminated successfully. The operation must also
    #  call  in case of failure.
    #  <p>
    #  The operation is not invoked if the circuit breaker is open, and the given fallback is called immediately. The
    #  circuit breaker also monitor the completion of the operation before a configure timeout. The operation is
    #  considered as failed if it does not terminate in time.
    #  <p>
    #  This method returns a  object to retrieve the status and result of the operation, with the status
    #  being a success or a failure. If the fallback is called, the returned future is successfully completed with the
    #  value returned from the fallback. If the fallback throws an exception, the returned future is marked as failed.
    # @overload executeWithFallback(command,fallback)
    #   @param [Proc] command the operation
    #   @yield the fallback function. It gets an exception as parameter and returns the <em>fallback</em> result
    # @return [::Vertx::Future] a future object completed when the operation or its fallback completes
    def execute_with_fallback(*args)
      if args[0].class == Proc && block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:executeWithFallback, [Java::IoVertxCore::Handler.java_class,Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| args[0].call(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise, nil)) unless args[0] == nil }),(Proc.new { |event| ::Vertx::Util::Utils.to_object(yield(::Vertx::Util::Utils.from_throwable(event))) unless !block_given? })),::Vertx::Future, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling execute_with_fallback(#{args[0]},#{args[1]})"
      end
    end
    #  Same as {::VertxCircuitBreaker::CircuitBreaker#execute_and_report_with_fallback} but using the circuit breaker default
    #  fallback.
    # @overload executeAndReport(resultPromise,command)
    #   @param [::Vertx::Promise] resultPromise the promise on which the operation result is reported
    #   @yield the operation
    # @return [self]
    def execute_and_report(*args)
      if args[0].class.method_defined?(:j_del) && true
        @j_del.java_method(:executeAndReport, [Java::IoVertxCore::Promise.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise, nil)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling execute_and_report(#{args[0]})"
      end
    end
    #  Executes the given operation with the circuit breaker control. The operation is generally calling an
    #  <em>external</em> system. The operation receives a  object as parameter and <strong>must</strong>
    #  call  when the operation has terminated successfully. The operation must also
    #  call  in case of failure.
    #  <p>
    #  The operation is not invoked if the circuit breaker is open, and the given fallback is called immediately. The
    #  circuit breaker also monitor the completion of the operation before a configure timeout. The operation is
    #  considered as failed if it does not terminate in time.
    #  <p>
    #  Unlike {::VertxCircuitBreaker::CircuitBreaker#execute_with_fallback},  this method does return a  object, but
    #  let the caller pass a  object on which the result is reported. If the fallback is called, the future
    #  is successfully completed with the value returned by the fallback function. If the fallback throws an exception,
    #  the future is marked as failed.
    # @overload executeAndReportWithFallback(resultPromise,command,fallback)
    #   @param [::Vertx::Promise] resultPromise the promise on which the operation result is reported
    #   @param [Proc] command the operation
    #   @yield the fallback function. It gets an exception as parameter and returns the <em>fallback</em> result
    # @return [self]
    def execute_and_report_with_fallback(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Proc && block_given? && args[2] == nil
        @j_del.java_method(:executeAndReportWithFallback, [Java::IoVertxCore::Promise.java_class,Java::IoVertxCore::Handler.java_class,Java::JavaUtilFunction::Function.java_class]).call(args[0].j_del,(Proc.new { |event| args[1].call(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise, nil)) unless args[1] == nil }),(Proc.new { |event| ::Vertx::Util::Utils.to_object(yield(::Vertx::Util::Utils.from_throwable(event))) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling execute_and_report_with_fallback(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Same as {::VertxCircuitBreaker::CircuitBreaker#execute_with_fallback} but using a callback.
    # @overload executeCommandWithFallback(command,fallback,handler)
    #   @param [Proc] command the operation
    #   @param [Proc] fallback the fallback
    #   @yield the completion handler receiving either the operation result or the fallback result. The parameter is an  because if the fallback is not called, the error is passed to the handler.
    # @return [void]
    def execute_command_with_fallback(*args)
      if args[0].class == Proc && args[1].class == Proc && true
        if (block_given?)
          return @j_del.java_method(:executeCommandWithFallback, [Java::IoVertxCore::Handler.java_class,Java::JavaUtilFunction::Function.java_class,Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| args[0].call(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise, nil)) unless args[0] == nil }),(Proc.new { |event| ::Vertx::Util::Utils.to_object(args[1].call(::Vertx::Util::Utils.from_throwable(event))) unless args[1] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.from_object(ar.result) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:executeCommandWithFallback, [Java::IoVertxCore::Handler.java_class,Java::JavaUtilFunction::Function.java_class,Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| args[0].call(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise, nil)) unless args[0] == nil }),(Proc.new { |event| ::Vertx::Util::Utils.to_object(args[1].call(::Vertx::Util::Utils.from_throwable(event))) unless args[1] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.from_object(ar.result) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling execute_command_with_fallback(#{args[0]},#{args[1]})"
      end
    end
    #  Sets a  invoked when the circuit breaker state switches to close.
    # @overload closeHandler(handler)
    #   @yield the handler, must not be <code>null</code>
    # @return [self]
    def close_handler
      if true
        @j_del.java_method(:closeHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close_handler()"
      end
    end
    #  Same as {::VertxCircuitBreaker::CircuitBreaker#execute_with_fallback} but using the circuit breaker default fallback.
    # @overload executeCommand(command,handler)
    #   @param [Proc] command the operation
    #   @yield the completion handler receiving either the operation result or the fallback result. The parameter is an  because if the fallback is not called, the error is passed to the handler.
    # @return [void]
    def execute_command(*args)
      if args[0].class == Proc && true
        if (block_given?)
          return @j_del.java_method(:executeCommand, [Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| args[0].call(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise, nil)) unless args[0] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.from_object(ar.result) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:executeCommand, [Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| args[0].call(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise, nil)) unless args[0] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.from_object(ar.result) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling execute_command(#{args[0]})"
      end
    end
    #  Same as {::VertxCircuitBreaker::CircuitBreaker#execute_with_fallback} but using the circuit breaker default fallback.
    # @overload execute(command)
    #   @yield the operation
    # @return [::Vertx::Future] a future object completed when the operation or its fallback completes
    def execute
      if true
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:execute, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise, nil)) unless !block_given? })),::Vertx::Future, nil)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling execute()"
      end
    end
    #  Sets a  invoked when the circuit breaker state switches to open.
    # @overload openHandler(handler)
    #   @yield the handler, must not be <code>null</code>
    # @return [self]
    def open_handler
      if true
        @j_del.java_method(:openHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling open_handler()"
      end
    end
    # @overload name()
    # @return [String] the name of the circuit breaker.
    def name
      if !block_given?
        if @cached_name != nil
          return @cached_name
        end
        return @cached_name = @j_del.java_method(:name, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling name()"
      end
    end
    #  Resets the circuit breaker state (number of failure set to 0 and state set to closed).
    # @overload reset()
    # @return [self]
    def reset
      if !block_given?
        @j_del.java_method(:reset, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling reset()"
      end
    end
    #  Sets a  invoked when the circuit breaker state switches to half-open.
    # @overload halfOpenHandler(handler)
    #   @yield the handler, must not be <code>null</code>
    # @return [self]
    def half_open_handler
      if true
        @j_del.java_method(:halfOpenHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling half_open_handler()"
      end
    end
    #  Creates a new instance of {::VertxCircuitBreaker::CircuitBreaker}.
    # @overload create(name,vertx)
    #   @param [String] name the name
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    # @overload create(name,vertx,options)
    #   @param [String] name the name
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    #   @param [Hash{String => Object}] options the configuration option
    # @return [::VertxCircuitBreaker::CircuitBreaker] the created instance
    def self.create(*args)
      if args[0].class == String && args[1].class.method_defined?(:j_del) && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCircuitbreaker::CircuitBreaker.java_method(:create, [Java::java.lang.String.java_class,Java::IoVertxCore::Vertx.java_class]).call(args[0],args[1].j_del),::VertxCircuitBreaker::CircuitBreaker)
      elsif args[0].class == String && args[1].class.method_defined?(:j_del) && args[2].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCircuitbreaker::CircuitBreaker.java_method(:create, [Java::java.lang.String.java_class,Java::IoVertxCore::Vertx.java_class,Java::IoVertxCircuitbreaker::CircuitBreakerOptions.java_class]).call(args[0],args[1].j_del,Java::IoVertxCircuitbreaker::CircuitBreakerOptions.new(::Vertx::Util::Utils.to_json_object(args[2]))),::VertxCircuitBreaker::CircuitBreaker)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    # @overload state()
    # @return [:OPEN,:CLOSED,:HALF_OPEN] the current state.
    def state
      if !block_given?
        return @j_del.java_method(:state, []).call().name.intern
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling state()"
      end
    end
    #  Sets a <em>default</em>  invoked when the bridge is open to handle the "request", or on failure
    #  if {Hash{String => Object}#is_fallback_on_failure} is enabled.
    #  <p>
    #  The function gets the exception as parameter and returns the <em>fallback</em> result.
    # @overload fallback(handler)
    #   @yield the handler
    # @return [self]
    def fallback(*args)
      if block_given? && args[0] == nil
        @j_del.java_method(:fallback, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| ::Vertx::Util::Utils.to_object(yield(::Vertx::Util::Utils.from_throwable(event))) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fallback(#{args[0]})"
      end
    end
    #  Closes the circuit breaker. It stops sending events on its state on the event bus.
    #  This method is not related to the <code>close</code> state of the circuit breaker. To set the circuit breaker in the
    #  <code>close</code> state, use {::VertxCircuitBreaker::CircuitBreaker#reset}.
    # @overload close()
    # @return [self]
    def close
      if !block_given?
        @j_del.java_method(:close, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    # @overload failureCount()
    # @return [Fixnum] the current number of failures.
    def failure_count
      if !block_given?
        return @j_del.java_method(:failureCount, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling failure_count()"
      end
    end
    #  Explicitly opens the circuit.
    # @overload open()
    # @return [self]
    def open
      if !block_given?
        @j_del.java_method(:open, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling open()"
      end
    end
  end
end
