require 'vertx/promise'
require 'vertx/vertx'
require 'vertx-health-checks/health_checks'
require 'vertx-web/routing_context'
require 'vertx-auth-common/auth_provider'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.healthchecks.HealthCheckHandler
module VertxHealthChecks
  #  A Vert.x Web handler on which you register health check procedure. It computes the outcome status (`UP` or `DOWN`)
  #  . When the handler process a HTTP request, it computes the global outcome and build a HTTP response as follows:
  #  <p>
  #  <ul>
  #  <li>204 - status is `UP` but no procedures installed (no payload)</li>
  #  <li>200 - status is `UP`, the payload contains the result of the installed procedures</li>
  #  <li>503 - status is `DOWN`, the payload contains the result of the installed procedures</li>
  #  <li>500 - status is `DOWN`, the payload contains the result of the installed procedures, one of the
  #  procedure has failed</li>
  #  </ul>
  class HealthCheckHandler
    # @private
    # @param j_del [::VertxHealthChecks::HealthCheckHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxHealthChecks::HealthCheckHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == HealthCheckHandler
    end
    def @@j_api_type.wrap(obj)
      HealthCheckHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtHealthchecks::HealthCheckHandler.java_class
    end
    #  Creates an instance of the default implementation of the {::VertxHealthChecks::HealthCheckHandler}.
    # @overload createWithHealthChecks(hc)
    #   @param [::VertxHealthChecks::HealthChecks] hc the health checks object to use
    # @overload createWithHealthChecks(hc,provider)
    #   @param [::VertxHealthChecks::HealthChecks] hc the health checks object to use, must not be <code>null</code>
    #   @param [::VertxAuthCommon::AuthProvider] provider 
    # @return [::VertxHealthChecks::HealthCheckHandler] the created instance
    def self.create_with_health_checks(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtHealthchecks::HealthCheckHandler.java_method(:createWithHealthChecks, [Java::IoVertxExtHealthchecks::HealthChecks.java_class]).call(args[0].j_del),::VertxHealthChecks::HealthCheckHandler)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtHealthchecks::HealthCheckHandler.java_method(:createWithHealthChecks, [Java::IoVertxExtHealthchecks::HealthChecks.java_class,Java::IoVertxExtAuth::AuthProvider.java_class]).call(args[0].j_del,args[1].j_del),::VertxHealthChecks::HealthCheckHandler)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_with_health_checks(#{args[0]},#{args[1]})"
      end
    end
    #  Unregisters a procedure.
    # @overload unregister(name)
    #   @param [String] name the name of the procedure
    # @return [self]
    def unregister(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:unregister, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling unregister(#{args[0]})"
      end
    end
    #  Creates an instance of the default implementation of the {::VertxHealthChecks::HealthCheckHandler}.
    #  This function creates a new instance of {::VertxHealthChecks::HealthChecks}.
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance, must not be <code>null</code>
    # @overload create(vertx,provider)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance, must not be <code>null</code>
    #   @param [::VertxAuthCommon::AuthProvider] provider the Authentication provider used to authenticate the HTTP request
    # @return [::VertxHealthChecks::HealthCheckHandler] the created instance
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtHealthchecks::HealthCheckHandler.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxHealthChecks::HealthCheckHandler)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtHealthchecks::HealthCheckHandler.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtAuth::AuthProvider.java_class]).call(args[0].j_del,args[1].j_del),::VertxHealthChecks::HealthCheckHandler)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Something has happened, so handle it.
    # @overload handle(event)
    #   @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle(#{args[0]})"
      end
    end
    #  Registers a health check procedure.
    #  <p>
    #  The procedure is a  taking a  of {Hash{String => Object}} as parameter. Procedures are
    #  asynchronous, and <strong>must</strong> complete or fail the given . If the future object is
    #  failed, the procedure outcome is considered as `DOWN`. If the future is completed without any object, the
    #  procedure outcome is considered as `UP`. If the future is completed with a (not-null) {Hash{String => Object}}, the
    #  procedure outcome is the received status.
    # @overload register(name,procedure)
    #   @param [String] name the name of the procedure, must not be <code>null</code> or empty
    #   @yield the procedure, must not be <code>null</code>
    # @overload register(name,timeout,procedure)
    #   @param [String] name the name of the procedure, must not be <code>null</code> or empty
    #   @param [Fixnum] timeout the procedure timeout
    #   @yield the procedure, must not be <code>null</code>
    # @return [self]
    def register(*args)
      if args[0].class == String && true && args[1] == nil
        @j_del.java_method(:register, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise,::Vertx::Util::data_object_type(Java::IoVertxExtHealthchecks::Status))) unless !block_given? }))
        return self
      elsif args[0].class == String && args[1].class == Fixnum && true
        @j_del.java_method(:register, [Java::java.lang.String.java_class,Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise,::Vertx::Util::data_object_type(Java::IoVertxExtHealthchecks::Status))) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling register(#{args[0]},#{args[1]})"
      end
    end
  end
end
