require 'vertx-pg-client/pg_connection'
require 'vertx/vertx'
require 'vertx-pg-client/pg_channel'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.pgclient.pubsub.PgSubscriber
module VertxPgClient
  #  A class for managing subscriptions using <code>LISTEN/UNLISTEN</code> to Postgres channels.
  #  <p/>
  #  The subscriber manages a single connection to Postgres.
  class PgSubscriber
    # @private
    # @param j_del [::VertxPgClient::PgSubscriber] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxPgClient::PgSubscriber] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == PgSubscriber
    end
    def @@j_api_type.wrap(obj)
      PgSubscriber.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxPgclientPubsub::PgSubscriber.java_class
    end
    #  Create a subscriber.
    # @overload subscriber(vertx,options)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [Hash{String => Object}] options the connect options
    # @return [::VertxPgClient::PgSubscriber] the subscriber
    def self.subscriber(*args)
      if args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxPgclientPubsub::PgSubscriber.java_method(:subscriber, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxPgclient::PgConnectOptions.java_class]).call(args[0].j_del,Java::IoVertxPgclient::PgConnectOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxPgClient::PgSubscriber)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling subscriber(#{args[0]},#{args[1]})"
      end
    end
    #  Return a channel for the given <code>name</code>.
    # @overload channel(name)
    #   @param [String] name the channel name <p/> This will be the name of the channel exactly as held by Postgres for sending notifications. Internally this name will be truncated to the Postgres identifier maxiumum length of <code>(NAMEDATALEN = 64) - 1 == 63</code> characters, and prepared as a quoted identifier without unicode escape sequence support for use in <code>LISTEN/UNLISTEN</code> commands. Examples of channel names and corresponding <code>NOTIFY</code> commands: <ul> <li>when <code>name == "the_channel"</code>: <code>NOTIFY the_channel, 'msg'</code>, <code>NOTIFY The_Channel, 'msg'</code>, or <code>NOTIFY "the_channel", 'msg'</code> succeed in delivering a message to the created channel </li> <li>when <code>name == "The_Channel"</code>: <code>NOTIFY "The_Channel", 'msg'</code>, succeeds in delivering a message to the created channel </li> <li></li> </ul>
    # @return [::VertxPgClient::PgChannel] the channel
    def channel(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:channel, [Java::java.lang.String.java_class]).call(args[0]),::VertxPgClient::PgChannel)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling channel(#{args[0]})"
      end
    end
    # @overload closed()
    # @return [true,false] whether the subscriber is closed
    def closed?
      if !block_given?
        return @j_del.java_method(:closed, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling closed?()"
      end
    end
    #  Set an handler called when the subscriber is closed.
    # @overload closeHandler(handler)
    #   @yield the handler
    # @return [self]
    def close_handler
      if true
        @j_del.java_method(:closeHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close_handler()"
      end
    end
    #  Set the reconnect policy that is executed when the subscriber is disconnected.
    #  <p/>
    #  When the subscriber is disconnected, the <code>policy</code> function is called with the actual
    #  number of retries and returns an <code>amountOfTime</code> value:
    #  <ul>
    #    <li>when <code>amountOfTime < 0</code>: the subscriber is closed and there is no retry</li>
    #    <li>when <code>amountOfTime == 0</code>: the subscriber retries to connect immediately</li>
    #    <li>when <code>amountOfTime > 0</code>: the subscriber retries after <code>amountOfTime</code> milliseconds</li>
    #  </ul>
    #  <p/>
    #  The default policy does not perform any retries.
    # @overload reconnectPolicy(policy)
    #   @yield the policy to set
    # @return [self]
    def reconnect_policy(*args)
      if block_given? && args[0] == nil
        @j_del.java_method(:reconnectPolicy, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(event) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling reconnect_policy(#{args[0]})"
      end
    end
    #  Close the subscriber, the retry policy will not be invoked.
    # @overload close()
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    # @overload actualConnection()
    # @return [::VertxPgClient::PgConnection] the actual connection to Postgres, it might be <code>null</code>
    def actual_connection
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:actualConnection, []).call(),::VertxPgClient::PgConnection)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling actual_connection()"
      end
    end
    #  Connect the subscriber to Postgres.
    # @overload connect(handler)
    #   @yield the handler notified of the connection success or failure
    # @return [self]
    def connect
      if true
        if (block_given?)
          @j_del.java_method(:connect, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:connect, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling connect()"
      end
    end
  end
end
