require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.rabbitmq.Envelope
module VertxRabbitmq
  #  Like Envelope.
  class Envelope
    # @private
    # @param j_del [::VertxRabbitmq::Envelope] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxRabbitmq::Envelope] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Envelope
    end
    def @@j_api_type.wrap(obj)
      Envelope.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxRabbitmq::Envelope.java_class
    end
    #  Get the redelivery flag included in this parameter envelope. This is a
    #  hint as to whether this message may have been delivered before (but not
    #  acknowledged). If the flag is not set, the message definitely has not
    #  been delivered before. If it is set, it may have been delivered before.
    # @overload isRedelivery()
    # @return [true,false] the redelivery flag
    def redelivery?
      if !block_given?
        if @cached_is_redelivery != nil
          return @cached_is_redelivery
        end
        return @cached_is_redelivery = @j_del.java_method(:isRedelivery, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling redelivery?()"
      end
    end
    #  Get the delivery tag included in this parameter envelope
    # @overload deliveryTag()
    # @return [Fixnum] the delivery tag
    def delivery_tag
      if !block_given?
        if @cached_delivery_tag != nil
          return @cached_delivery_tag
        end
        return @cached_delivery_tag = @j_del.java_method(:deliveryTag, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling delivery_tag()"
      end
    end
    #  Get the name of the exchange included in this parameter envelope
    # @overload exchange()
    # @return [String] the exchange
    def exchange
      if !block_given?
        if @cached_exchange != nil
          return @cached_exchange
        end
        return @cached_exchange = @j_del.java_method(:exchange, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exchange()"
      end
    end
    #  Get the routing key included in this parameter envelope
    # @overload routingKey()
    # @return [String] the routing key
    def routing_key
      if !block_given?
        if @cached_routing_key != nil
          return @cached_routing_key
        end
        return @cached_routing_key = @j_del.java_method(:routingKey, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling routing_key()"
      end
    end
  end
end
