require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.shell.cli.CliToken
module VertxShell
  #  A parsed token in the command line interface.
  class CliToken
    # @private
    # @param j_del [::VertxShell::CliToken] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxShell::CliToken] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == CliToken
    end
    def @@j_api_type.wrap(obj)
      CliToken.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtShellCli::CliToken.java_class
    end
    #  Create a new blank token.
    # @overload createBlank(blank)
    #   @param [String] blank the blank value
    # @return [::VertxShell::CliToken] the token
    def self.create_blank(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtShellCli::CliToken.java_method(:createBlank, [Java::java.lang.String.java_class]).call(args[0]),::VertxShell::CliToken)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_blank(#{args[0]})"
      end
    end
    #  Create a text token.
    # @overload createText(text)
    #   @param [String] text the text
    # @return [::VertxShell::CliToken] the token
    def self.create_text(*args)
      if args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtShellCli::CliToken.java_method(:createText, [Java::java.lang.String.java_class]).call(args[0]),::VertxShell::CliToken)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create_text(#{args[0]})"
      end
    end
    # @overload raw()
    # @return [String] the raw token value, that may contain unescaped chars, for instance 
    def raw
      if !block_given?
        return @j_del.java_method(:raw, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling raw()"
      end
    end
    # @overload isBlank()
    # @return [true,false] true when it's a blank token
    def blank?
      if !block_given?
        return @j_del.java_method(:isBlank, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling blank?()"
      end
    end
    # @overload value()
    # @return [String] the token value
    def value
      if !block_given?
        return @j_del.java_method(:value, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling value()"
      end
    end
    #  Tokenize the string argument and return a list of tokens.
    # @overload tokenize(s)
    #   @param [String] s the tokenized string
    # @return [Array<::VertxShell::CliToken>] the tokens
    def self.tokenize(*args)
      if args[0].class == String && !block_given?
        return Java::IoVertxExtShellCli::CliToken.java_method(:tokenize, [Java::java.lang.String.java_class]).call(args[0]).to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxShell::CliToken) }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling tokenize(#{args[0]})"
      end
    end
    # @overload isText()
    # @return [true,false] true when it's a text token
    def text?
      if !block_given?
        return @j_del.java_method(:isText, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling text?()"
      end
    end
  end
end
