require 'vertx-sql-client/row_iterator'
require 'vertx-sql-client/sql_result'
require 'vertx-sql-client/row'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.RowSet
module VertxSqlClient
  #  A set of rows.
  class RowSet < ::VertxSqlClient::SqlResult
    # @private
    # @param j_del [::VertxSqlClient::RowSet] the java delegate
    def initialize(j_del)
      super(j_del, ::VertxSqlClient::RowSet.j_api_type)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSqlClient::RowSet] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == RowSet
    end
    def @@j_api_type.wrap(obj)
      RowSet.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxSqlclient::RowSet.java_class
    end
    # @overload next()
    # @return [::VertxSqlClient::RowSet]
    def next
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:next, []).call(),::VertxSqlClient::RowSet)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling next()"
      end
    end
    # @overload iterator()
    # @return [::VertxSqlClient::RowIterator]
    def iterator
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:iterator, []).call(),::VertxSqlClient::RowIterator)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling iterator()"
      end
    end
    #  Get the result value.
    # @overload value()
    # @return [::VertxSqlClient::RowSet] the result
    def value
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:value, []).call(),::VertxSqlClient::RowSet)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling value()"
      end
    end
  end
end
