require 'vertx-stomp/stomp_server_handler'
require 'vertx/server_web_socket'
require 'vertx/net_server'
require 'vertx/vertx'
require 'vertx-stomp/server_frame'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.stomp.StompServer
module VertxStomp
  #  Defines a STOMP server. STOMP servers delegates to a {::VertxStomp::StompServerHandler} that let customize the behavior of
  #  the server. By default, it uses a handler compliant with the STOMP specification, but let you change anything.
  class StompServer
    # @private
    # @param j_del [::VertxStomp::StompServer] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxStomp::StompServer] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == StompServer
    end
    def @@j_api_type.wrap(obj)
      StompServer.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtStomp::StompServer.java_class
    end
    #  Configures the {::VertxStomp::StompServerHandler}. You must calls this method before calling the {::VertxStomp::StompServer#listen} method.
    # @overload handler(handler)
    #   @param [::VertxStomp::StompServerHandler] handler the handler
    # @return [self]
    def handler(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:handler, [Java::IoVertxExtStomp::StompServerHandler.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handler(#{args[0]})"
      end
    end
    #  Gets the  able to manage web socket connections. If the web socket bridge is disabled, it returns
    #  <code>null</code>.
    # @overload webSocketHandler()
    # @return [Proc] the handler that can be passed to {::Vertx::HttpServer#websocket_handler}.
    def web_socket_handler
      if !block_given?
        return ::Vertx::Util::Utils.to_handler_proc(@j_del.java_method(:webSocketHandler, []).call()) { |val| val.j_del }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling web_socket_handler()"
      end
    end
    #  Gets the port on which the server is listening.
    #  <p/>
    #  This is useful if you bound the server specifying 0 as port number signifying an ephemeral port.
    # @overload actualPort()
    # @return [Fixnum] the port
    def actual_port
      if !block_given?
        return @j_del.java_method(:actualPort, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling actual_port()"
      end
    end
    #  Configures the handler that is invoked every time a frame is going to be written to the "wire". It lets you log
    #  the frames, but also adapt the frame if needed.
    # @overload writingFrameHandler(handler)
    #   @yield the handler, must not be <code>null</code>
    # @return [self]
    def writing_frame_handler
      if true
        @j_del.java_method(:writingFrameHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxStomp::ServerFrame)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling writing_frame_handler()"
      end
    end
    # @overload stompHandler()
    # @return [::VertxStomp::StompServerHandler] the {::VertxStomp::StompServerHandler} used by this server.
    def stomp_handler
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:stompHandler, []).call(),::VertxStomp::StompServerHandler)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling stomp_handler()"
      end
    end
    # @overload options()
    # @return [Hash{String => Object}] the server options
    def options
      if !block_given?
        return @j_del.java_method(:options, []).call() != nil ? JSON.parse(@j_del.java_method(:options, []).call().toJson.encode) : nil
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling options()"
      end
    end
    #  Checks whether or not the server is listening.
    # @overload isListening()
    # @return [true,false] <code>true</code> if the server is listening, <code>false</code> otherwise
    def listening?
      if !block_given?
        return @j_del.java_method(:isListening, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling listening?()"
      end
    end
    # @overload vertx()
    # @return [::Vertx::Vertx] the instance of vert.x used by the server.
    def vertx
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:vertx, []).call(),::Vertx::Vertx)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling vertx()"
      end
    end
    #  Creates a {::VertxStomp::StompServer} based on the default Stomp Server implementation.
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx the vert.x instance to use
    # @overload create(vertx,options)
    #   @param [::Vertx::Vertx] vertx the vert.x instance to use
    #   @param [Hash{String => Object}] options the server options
    # @overload create(vertx,netServer)
    #   @param [::Vertx::Vertx] vertx the vert.x instance to use
    #   @param [::Vertx::NetServer] netServer the Net server used by the STOMP server
    # @overload create(vertx,net,options)
    #   @param [::Vertx::Vertx] vertx the vert.x instance to use
    #   @param [::Vertx::NetServer] net the Net server used by the STOMP server
    #   @param [Hash{String => Object}] options the server options
    # @return [::VertxStomp::StompServer] the created {::VertxStomp::StompServer}
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtStomp::StompServer.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxStomp::StompServer)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtStomp::StompServer.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtStomp::StompServerOptions.java_class]).call(args[0].j_del,Java::IoVertxExtStomp::StompServerOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxStomp::StompServer)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtStomp::StompServer.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCoreNet::NetServer.java_class]).call(args[0].j_del,args[1].j_del),::VertxStomp::StompServer)
      elsif args[0].class.method_defined?(:j_del) && args[1].class.method_defined?(:j_del) && args[2].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtStomp::StompServer.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCoreNet::NetServer.java_class,Java::IoVertxExtStomp::StompServerOptions.java_class]).call(args[0].j_del,args[1].j_del,Java::IoVertxExtStomp::StompServerOptions.new(::Vertx::Util::Utils.to_json_object(args[2]))),::VertxStomp::StompServer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Closes the server.
    # @overload close()
    # @overload close(completionHandler)
    #   @yield handler called once the server has been stopped
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      elsif true
        if (block_given?)
          return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
    #  Connects the STOMP server to the given port / interface. Once the socket it bounds calls the given handler with
    #  the result. The result may be a failure if the socket is already used.
    # @overload listen()
    # @overload listen(port)
    #   @param [Fixnum] port the port
    # @overload listen(handler)
    #   @yield the handler to call with the result
    # @overload listen(port,host)
    #   @param [Fixnum] port the port
    #   @param [String] host the interface
    # @overload listen(port,handler)
    #   @param [Fixnum] port the port
    #   @yield the handler to call with the result
    # @overload listen(port,host,handler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host / interface
    #   @yield the handler to call with the result
    # @return [self]
    def listen(*args)
      if !block_given? && args[0] == nil && args[1] == nil
        @j_del.java_method(:listen, []).call()
        return self
      elsif args[0].class == Fixnum && !block_given? && args[1] == nil
        @j_del.java_method(:listen, [Java::int.java_class]).call(args[0])
        return self
      elsif true && args[0] == nil && args[1] == nil
        if (block_given?)
          @j_del.java_method(:listen, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxStomp::StompServer) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listen, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxStomp::StompServer) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxStomp::StompServer.j_api_type)
        end
      elsif args[0].class == Fixnum && args[1].class == String && !block_given?
        @j_del.java_method(:listen, [Java::int.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      elsif args[0].class == Fixnum && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:listen, [Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxStomp::StompServer) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listen, [Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxStomp::StompServer) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxStomp::StompServer.j_api_type)
        end
      elsif args[0].class == Fixnum && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:listen, [Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxStomp::StompServer) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:listen, [Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxStomp::StompServer) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxStomp::StompServer.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling listen(#{args[0]},#{args[1]})"
      end
    end
  end
end
