require 'vertx-web-common/form_data_part'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.multipart.MultipartForm
module VertxWebCommon
  #  A multipart form.
  class MultipartForm
    # @private
    # @param j_del [::VertxWebCommon::MultipartForm] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebCommon::MultipartForm] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MultipartForm
    end
    def @@j_api_type.wrap(obj)
      MultipartForm.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebMultipart::MultipartForm.java_class
    end
    #  Add a binary file upload form data part.
    # @overload binaryFileUpload(name,filename,pathname,mediaType)
    #   @param [String] name name of the parameter
    #   @param [String] filename filename of the file
    #   @param [String] pathname the pathname of the file
    #   @param [String] mediaType the MIME type of the file
    # @return [self]
    def binary_file_upload(*args)
      if args[0].class == String && args[1].class == String && args[2].class == String && args[3].class == String && !block_given?
        @j_del.java_method(:binaryFileUpload, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2],args[3])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling binary_file_upload(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    #  Add a text file upload form data part.
    # @overload textFileUpload(name,filename,pathname,mediaType)
    #   @param [String] name name of the parameter
    #   @param [String] filename filename of the file
    #   @param [String] pathname the pathname of the file
    #   @param [String] mediaType the MIME type of the file
    # @return [self]
    def text_file_upload(*args)
      if args[0].class == String && args[1].class == String && args[2].class == String && args[3].class == String && !block_given?
        @j_del.java_method(:textFileUpload, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1],args[2],args[3])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling text_file_upload(#{args[0]},#{args[1]},#{args[2]},#{args[3]})"
      end
    end
    # @overload create()
    # @return [::VertxWebCommon::MultipartForm] a multipart form instance
    def self.create
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebMultipart::MultipartForm.java_method(:create, []).call(),::VertxWebCommon::MultipartForm)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create()"
      end
    end
    #  Add an attribute form data part.
    # @overload attribute(name,value)
    #   @param [String] name the name of the attribute
    #   @param [String] value the value of the attribute
    # @return [self]
    def attribute(*args)
      if args[0].class == String && args[1].class == String && !block_given?
        @j_del.java_method(:attribute, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling attribute(#{args[0]},#{args[1]})"
      end
    end
  end
end
