require 'vertx-web-common/template_engine'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.templ.rocker.RockerTemplateEngine
module VertxWebTemplRocker
  #  A template engine that uses the Rocker library.
  class RockerTemplateEngine < ::VertxWebCommon::TemplateEngine
    # @private
    # @param j_del [::VertxWebTemplRocker::RockerTemplateEngine] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebTemplRocker::RockerTemplateEngine] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == RockerTemplateEngine
    end
    def @@j_api_type.wrap(obj)
      RockerTemplateEngine.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebTemplRocker::RockerTemplateEngine.java_class
    end
    #  Create a template engine using a custom extension
    # @overload create()
    # @overload create(extension)
    #   @param [String] extension 
    # @return [::VertxWebTemplRocker::RockerTemplateEngine] the engine
    def self.create(*args)
      if !block_given? && args[0] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebTemplRocker::RockerTemplateEngine.java_method(:create, []).call(),::VertxWebTemplRocker::RockerTemplateEngine)
      elsif args[0].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebTemplRocker::RockerTemplateEngine.java_method(:create, [Java::java.lang.String.java_class]).call(args[0]),::VertxWebTemplRocker::RockerTemplateEngine)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    #  Default template extension
    def self.DEFAULT_TEMPLATE_EXTENSION
      Java::IoVertxExtWebTemplRocker::RockerTemplateEngine.DEFAULT_TEMPLATE_EXTENSION
    end
  end
end
