require 'vertx-web/session_store'
require 'vertx/vertx'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.sstore.ClusteredSessionStore
module VertxWeb
  #  A session store which stores sessions in a distributed map so they are available across the cluster.
  class ClusteredSessionStore < ::VertxWeb::SessionStore
    # @private
    # @param j_del [::VertxWeb::ClusteredSessionStore] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::ClusteredSessionStore] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ClusteredSessionStore
    end
    def @@j_api_type.wrap(obj)
      ClusteredSessionStore.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebSstore::ClusteredSessionStore.java_class
    end
    #  Create a session store.<p/>
    # 
    #  The retry timeout value, configures how long the session handler will retry to get a session from the store
    #  when it is not found.
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    # @overload create(vertx,sessionMapName)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    #   @param [String] sessionMapName the session map name
    # @overload create(vertx,retryTimeout)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    #   @param [Fixnum] retryTimeout the store retry timeout, in ms
    # @overload create(vertx,sessionMapName,retryTimeout)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    #   @param [String] sessionMapName the session map name
    #   @param [Fixnum] retryTimeout the store retry timeout, in ms
    # @return [::VertxWeb::ClusteredSessionStore] the session store
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebSstore::ClusteredSessionStore.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxWeb::ClusteredSessionStore)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == String && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebSstore::ClusteredSessionStore.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(args[0].j_del,args[1]),::VertxWeb::ClusteredSessionStore)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Fixnum && !block_given? && args[2] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebSstore::ClusteredSessionStore.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::long.java_class]).call(args[0].j_del,args[1]),::VertxWeb::ClusteredSessionStore)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == String && args[2].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebSstore::ClusteredSessionStore.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::long.java_class]).call(args[0].j_del,args[1],args[2]),::VertxWeb::ClusteredSessionStore)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Default length for a session id.
    #  More info: https://www.owasp.org/index.php/Session_Management_Cheat_Sheet
    def self.DEFAULT_SESSIONID_LENGTH
      Java::IoVertxExtWebSstore::ClusteredSessionStore.DEFAULT_SESSIONID_LENGTH
    end
    #  The default name used for the session map
    def self.DEFAULT_SESSION_MAP_NAME
      Java::IoVertxExtWebSstore::ClusteredSessionStore.DEFAULT_SESSION_MAP_NAME
    end
    #  Default retry time out, in ms, for a session not found in this store.
    def self.DEFAULT_RETRY_TIMEOUT
      Java::IoVertxExtWebSstore::ClusteredSessionStore.DEFAULT_RETRY_TIMEOUT
    end
  end
end
