require 'vertx-web/routing_context'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.FaviconHandler
module VertxWeb
  #  A handler that serves favicons.
  #  <p>
  #  If no file system path is specified it will attempt to serve a resource called `favicon.ico` from the classpath.
  class FaviconHandler
    # @private
    # @param j_del [::VertxWeb::FaviconHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::FaviconHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == FaviconHandler
    end
    def @@j_api_type.wrap(obj)
      FaviconHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandler::FaviconHandler.java_class
    end
    #  Create a handler attempting to load favicon file from the specified path, and with the specified max cache time
    # @overload create()
    # @overload create(path)
    #   @param [String] path the path
    # @overload create(maxAgeSeconds)
    #   @param [Fixnum] maxAgeSeconds max how long the file will be cached by browser, in seconds
    # @overload create(path,maxAgeSeconds)
    #   @param [String] path the path
    #   @param [Fixnum] maxAgeSeconds max how long the file will be cached by browser, in seconds
    # @return [::VertxWeb::FaviconHandler] the handler
    def self.create(*args)
      if !block_given? && args[0] == nil && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::FaviconHandler.java_method(:create, []).call(),::VertxWeb::FaviconHandler)
      elsif args[0].class == String && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::FaviconHandler.java_method(:create, [Java::java.lang.String.java_class]).call(args[0]),::VertxWeb::FaviconHandler)
      elsif args[0].class == Fixnum && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::FaviconHandler.java_method(:create, [Java::long.java_class]).call(args[0]),::VertxWeb::FaviconHandler)
      elsif args[0].class == String && args[1].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::FaviconHandler.java_method(:create, [Java::java.lang.String.java_class,Java::long.java_class]).call(args[0],args[1]),::VertxWeb::FaviconHandler)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Something has happened, so handle it.
    # @overload handle(event)
    #   @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(args[0].j_del)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handle(#{args[0]})"
      end
    end
    #  The default max age in seconds as set in the cache-control header
    def self.DEFAULT_MAX_AGE_SECONDS
      Java::IoVertxExtWebHandler::FaviconHandler.DEFAULT_MAX_AGE_SECONDS
    end
  end
end
