require 'vertx-web/routing_context'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.Route
module VertxWeb
  #  A route is a holder for a set of criteria which determine whether an HTTP request or failure should be routed
  #  to a handler.
  class Route
    # @private
    # @param j_del [::VertxWeb::Route] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::Route] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Route
    end
    def @@j_api_type.wrap(obj)
      Route.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWeb::Route.java_class
    end
    #  Append a failure handler to the route failure handlers list. The router routes failures to failurehandlers depending on whether the various
    #  criteria such as method, path, etc match. When method, path, etc are the same for different routes, You should add multiple
    #  failure handlers to the same route object rather than creating two different routes objects with one failure handler for route
    # @overload failureHandler(failureHandler)
    #   @yield the request handler
    # @return [self]
    def failure_handler
      if true
        @j_del.java_method(:failureHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling failure_handler()"
      end
    end
    #  Append a request handler to the route handlers list. The router routes requests to handlers depending on whether the various
    #  criteria such as method, path, etc match. When method, path, etc are the same for different routes, You should add multiple
    #  handlers to the same route object rather than creating two different routes objects with one handler for route
    # @overload handler(requestHandler)
    #   @yield the request handler
    # @return [self]
    def handler
      if true
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handler()"
      end
    end
    #  Set the path prefix as a regular expression. If set then this route will only match request URI paths, the beginning
    #  of which match the regex. Only a single path or path regex can be set for a route.
    # @overload pathRegex(path)
    #   @param [String] path the path regex
    # @return [self]
    def path_regex(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:pathRegex, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling path_regex(#{args[0]})"
      end
    end
    #  Specify this is the last route for the router.
    # @overload last()
    # @return [self]
    def last
      if !block_given?
        @j_del.java_method(:last, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling last()"
      end
    end
    #  Add an HTTP method for this route. By default a route will match all HTTP methods. If any are specified then the route
    #  will only match any of the specified methods
    # @overload method(method)
    #   @param [:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER] method the HTTP method to add
    # @return [self]
    def method(*args)
      if args[0].class == Symbol && !block_given?
        @j_del.java_method(:method, [Java::IoVertxCoreHttp::HttpMethod.java_class]).call(Java::IoVertxCoreHttp::HttpMethod.valueOf(args[0].to_s))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling method(#{args[0]})"
      end
    end
    # @overload methods()
    # @return [Set<:OPTIONS,:GET,:HEAD,:POST,:PUT,:DELETE,:TRACE,:CONNECT,:PATCH,:OTHER>] the http methods accepted by this route
    def methods
      if !block_given?
        return ::Vertx::Util::Utils.to_set(@j_del.java_method(:methods, []).call()).map! { |elt| elt.name.intern }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling methods()"
      end
    end
    #  If true then the normalised request path will be used when routing (e.g. removing duplicate /)
    #  Default is true
    # @overload useNormalisedPath(useNormalisedPath)
    #   @param [true,false] useNormalisedPath use normalised path for routing?
    # @return [self]
    def use_normalised_path(*args)
      if (args[0].class == TrueClass || args[0].class == FalseClass) && !block_given?
        @j_del.java_method(:useNormalisedPath, [Java::boolean.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling use_normalised_path(#{args[0]})"
      end
    end
    #  Add a virtual host filter for this route.
    # @overload virtualHost(hostnamePattern)
    #   @param [String] hostnamePattern the hostname pattern that should match <code>Host</code> header of the requests
    # @return [self]
    def virtual_host(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:virtualHost, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling virtual_host(#{args[0]})"
      end
    end
    #  Remove this route from the router
    # @overload remove()
    # @return [self]
    def remove
      if !block_given?
        @j_del.java_method(:remove, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove()"
      end
    end
    #  Set the path prefix for this route. If set then this route will only match request URI paths which start with this
    #  path prefix. Only a single path or path regex can be set for a route.
    # @overload path(path)
    #   @param [String] path the path prefix
    # @return [self]
    def path(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:path, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling path(#{args[0]})"
      end
    end
    #  Enable this route.
    # @overload enable()
    # @return [self]
    def enable
      if !block_given?
        @j_del.java_method(:enable, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling enable()"
      end
    end
    #  Disable this route. While disabled the router will not route any requests or failures to it.
    # @overload disable()
    # @return [self]
    def disable
      if !block_given?
        @j_del.java_method(:disable, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling disable()"
      end
    end
    # @overload getPath()
    # @return [String] the path prefix (if any) for this route
    def get_path
      if !block_given?
        return @j_del.java_method(:getPath, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_path()"
      end
    end
    #  Specify a blocking request handler for the route.
    #  This method works just like {::VertxWeb::Route#handler} excepted that it will run the blocking handler on a worker thread
    #  so that it won't block the event loop. Note that it's safe to call context.next() from the
    #  blocking handler as it will be executed on the event loop context (and not on the worker thread.
    # 
    #  If the blocking handler is ordered it means that any blocking handlers for the same context are never executed
    #  concurrently but always in the order they were called. The default value of ordered is true. If you do not want this
    #  behaviour and don't mind if your blocking handlers are executed in parallel you can set ordered to false.
    # @overload blockingHandler(requestHandler)
    #   @yield 
    # @overload blockingHandler(requestHandler,ordered)
    #   @param [Proc] requestHandler the blocking request handler
    #   @param [true,false] ordered if true handlers are executed in sequence, otherwise are run in parallel
    # @return [self]
    def blocking_handler(*args)
      if true && args[0] == nil && args[1] == nil
        @j_del.java_method(:blockingHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) unless !block_given? }))
        return self
      elsif args[0].class == Proc && (args[1].class == TrueClass || args[1].class == FalseClass) && !block_given?
        @j_del.java_method(:blockingHandler, [Java::IoVertxCore::Handler.java_class,Java::boolean.java_class]).call((Proc.new { |event| args[0].call(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) unless args[0] == nil }),args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling blocking_handler(#{args[0]},#{args[1]})"
      end
    end
    #  Add a content type produced by this route. Used for content based routing.
    # @overload produces(contentType)
    #   @param [String] contentType the content type
    # @return [self]
    def produces(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:produces, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling produces(#{args[0]})"
      end
    end
    #  When you add a new route with a regular expression, you can add named capture groups for parameters. <br/>
    #  However, if you need more complex parameters names (like "param_name"), you can add parameters names with
    #  this function. You have to name capture groups in regex with names: "p0", "p1", "p2", ... <br/>
    #  <br/>
    #  For example: If you declare route with regex \/(?<p0>[a-z]*)\/(?<p1>[a-z]*) and group names ["param_a", "param-b"]
    #  for uri /hello/world you receive inside pathParams() the parameter param_a = "hello"
    # @overload setRegexGroupsNames(groups)
    #   @param [Array<String>] groups group names
    # @return [self]
    def set_regex_groups_names(*args)
      if args[0].class == Array && !block_given?
        @j_del.java_method(:setRegexGroupsNames, [Java::JavaUtil::List.java_class]).call(args[0].map { |element| element })
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_regex_groups_names(#{args[0]})"
      end
    end
    #  Specify the order for this route. The router tests routes in that order.
    # @overload order(order)
    #   @param [Fixnum] order the order
    # @return [self]
    def order(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:order, [Java::int.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling order(#{args[0]})"
      end
    end
    #  Add a content type consumed by this route. Used for content based routing.
    # @overload consumes(contentType)
    #   @param [String] contentType the content type
    # @return [self]
    def consumes(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:consumes, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling consumes(#{args[0]})"
      end
    end
  end
end
