require 'vertx/async_file'
require 'vertx/pipe'
require 'vertx/buffer'
require 'vertx/write_stream'
require 'vertx/read_stream'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.http.HttpServerFileUpload
module Vertx
  #  Represents an file upload from an HTML FORM.
  class HttpServerFileUpload
    include ::Vertx::ReadStream
    # @private
    # @param j_del [::Vertx::HttpServerFileUpload] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::HttpServerFileUpload] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == HttpServerFileUpload
    end
    def @@j_api_type.wrap(obj)
      HttpServerFileUpload.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreHttp::HttpServerFileUpload.java_class
    end
    # @overload resume()
    # @return [self]
    def resume
      if !block_given?
        @j_del.java_method(:resume, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling resume()"
      end
    end
    # @overload charset()
    # @return [String] the charset for the upload
    def charset
      if !block_given?
        return @j_del.java_method(:charset, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling charset()"
      end
    end
    # @overload handler(handler)
    #   @yield 
    # @return [self]
    def handler
      if true
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling handler()"
      end
    end
    # @overload contentTransferEncoding()
    # @return [String] the contentTransferEncoding for the upload
    def content_transfer_encoding
      if !block_given?
        return @j_del.java_method(:contentTransferEncoding, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling content_transfer_encoding()"
      end
    end
    # @overload pause()
    # @return [self]
    def pause
      if !block_given?
        @j_del.java_method(:pause, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pause()"
      end
    end
    #  Stream the content of this upload to the given file on storage.
    # @overload streamToFileSystem(filename)
    #   @param [String] filename the name of the file
    # @return [self]
    def stream_to_file_system(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:streamToFileSystem, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling stream_to_file_system(#{args[0]})"
      end
    end
    # @overload file()
    # @return [::Vertx::AsyncFile] the async uploaded file when {::Vertx::HttpServerFileUpload#stream_to_file_system} has been used
    def file
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:file, []).call(),::Vertx::AsyncFile)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling file()"
      end
    end
    # @overload filename()
    # @return [String] the filename which was used when upload the file.
    def filename
      if !block_given?
        return @j_del.java_method(:filename, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling filename()"
      end
    end
    #  Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
    #  <p>
    #  Elements emitted by this stream will be written to the write stream until this stream ends or fails.
    #  <p>
    #  Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
    #  called with the result.
    # @overload pipeTo(dst,handler)
    #   @param [::Vertx::WriteStream] dst the destination write stream
    #   @yield 
    # @return [void]
    def pipe_to(*args)
      if args[0].class.method_defined?(:j_del) && true
        if (block_given?)
          return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0].j_del,block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe_to(#{args[0]})"
      end
    end
    #  The size of the upload may not be available until it is all read.
    #  Check {::Vertx::HttpServerFileUpload#is_size_available} to determine this
    # @overload size()
    # @return [Fixnum] the size of the upload (in bytes)
    def size
      if !block_given?
        return @j_del.java_method(:size, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling size()"
      end
    end
    # @overload endHandler(endHandler)
    #   @yield 
    # @return [self]
    def end_handler
      if true
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(nil) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling end_handler()"
      end
    end
    # @overload fetch(amount)
    #   @param [Fixnum] amount 
    # @return [self]
    def fetch(*args)
      if args[0].class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling fetch(#{args[0]})"
      end
    end
    # @overload name()
    # @return [String] the name of the attribute
    def name
      if !block_given?
        return @j_del.java_method(:name, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling name()"
      end
    end
    #  Pause this stream and return a  to transfer the elements of this stream to a destination .
    #  <p/>
    #  The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
    # @overload pipe()
    # @return [::Vertx::Pipe] a pipe
    def pipe
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pipe, []).call(),::Vertx::Pipe,::Vertx::Buffer.j_api_type)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling pipe()"
      end
    end
    # @overload isSizeAvailable()
    # @return [true,false] <code>true</code> if the size of the upload can be retrieved via {::Vertx::HttpServerFileUpload#size}.
    def size_available?
      if !block_given?
        return @j_del.java_method(:isSizeAvailable, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling size_available?()"
      end
    end
    # @overload contentType()
    # @return [String] the content type for the upload
    def content_type
      if !block_given?
        return @j_del.java_method(:contentType, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling content_type()"
      end
    end
    # @overload exceptionHandler(handler)
    #   @yield 
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling exception_handler()"
      end
    end
  end
end
