require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.json.pointer.JsonPointerIterator
module Vertx
  #  The JsonPointerIterator is used by the read/write algorithms of the {::Vertx::JsonPointer} to read/write the querying data structure <br/>
  # 
  #  Every method takes the currentValue as parameter, representing the actual value held by the query algorithm.<br/>
  # 
  #  Implementations of this interface should be stateless, so they can be reused<br/>
  # 
  #  You can implement this interface to query the structure you want using json pointers
  class JsonPointerIterator
    # @private
    # @param j_del [::Vertx::JsonPointerIterator] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::JsonPointerIterator] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == JsonPointerIterator
    end
    def @@j_api_type.wrap(obj)
      JsonPointerIterator.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreJsonPointer::JsonPointerIterator.java_class
    end
    # @overload objectContainsKey(currentValue,key)
    #   @param [Object] currentValue 
    #   @param [String] key object key
    # @return [true,false] <code>true</code> if current value is a queryable object that contains the specified key
    def object_contains_key?(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && args[1].class == String && !block_given?
        return @j_del.java_method(:objectContainsKey, [Java::java.lang.Object.java_class,Java::java.lang.String.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),args[1])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling object_contains_key?(#{args[0]},#{args[1]})"
      end
    end
    # @overload isObject(currentValue)
    #   @param [Object] currentValue 
    # @return [true,false] <code>true</code> if the current value is a queryable object
    def object?(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && !block_given?
        return @j_del.java_method(:isObject, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling object?(#{args[0]})"
      end
    end
    # @overload isNull(currentValue)
    #   @param [Object] currentValue 
    # @return [true,false] <code>true</code> if the current value is null/empty
    def null?(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && !block_given?
        return @j_del.java_method(:isNull, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling null?(#{args[0]})"
      end
    end
    #  Returns the object parameter with specified key.
    # @overload getObjectParameter(currentValue,key,createOnMissing)
    #   @param [Object] currentValue 
    #   @param [String] key object key
    #   @param [true,false] createOnMissing If the current value is an object that doesn't contain the key, put an empty object at provided key
    # @return [Object] the requested object parameter, or null if the method was not able to find it
    def get_object_parameter(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && args[1].class == String && (args[2].class == TrueClass || args[2].class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:getObjectParameter, [Java::java.lang.Object.java_class,Java::java.lang.String.java_class,Java::boolean.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),args[1],args[2]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_object_parameter(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Write object parameter at specified key
    # @overload writeObjectParameter(currentValue,key,value)
    #   @param [Object] currentValue 
    #   @param [String] key 
    #   @param [Object] value 
    # @return [true,false] true if the operation is successful
    def write_object_parameter?(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && args[1].class == String && ::Vertx::Util::unknown_type.accept?(args[2]) && !block_given?
        return @j_del.java_method(:writeObjectParameter, [Java::java.lang.Object.java_class,Java::java.lang.String.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),args[1],::Vertx::Util::Utils.to_object(args[2]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write_object_parameter?(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    # @overload isArray(currentValue)
    #   @param [Object] currentValue 
    # @return [true,false] <code>true</code> if the current value is a queryable array
    def array?(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && !block_given?
        return @j_del.java_method(:isArray, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling array?(#{args[0]})"
      end
    end
    #  Write array element at specified index
    # @overload writeArrayElement(currentValue,i,value)
    #   @param [Object] currentValue 
    #   @param [Fixnum] i 
    #   @param [Object] value 
    # @return [true,false] true if the operation is successful
    def write_array_element?(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && args[1].class == Fixnum && ::Vertx::Util::unknown_type.accept?(args[2]) && !block_given?
        return @j_del.java_method(:writeArrayElement, [Java::java.lang.Object.java_class,Java::int.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),args[1],::Vertx::Util::Utils.to_object(args[2]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling write_array_element?(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Append array element
    # @overload appendArrayElement(currentValue,value)
    #   @param [Object] currentValue 
    #   @param [Object] value 
    # @return [true,false] true if the operation is successful
    def append_array_element?(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && ::Vertx::Util::unknown_type.accept?(args[1]) && !block_given?
        return @j_del.java_method(:appendArrayElement, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),::Vertx::Util::Utils.to_object(args[1]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling append_array_element?(#{args[0]},#{args[1]})"
      end
    end
    #  Move the iterator the the array element at specified index
    # @overload getArrayElement(currentValue,i)
    #   @param [Object] currentValue 
    #   @param [Fixnum] i array index
    # @return [Object] the request array element, or null if the method was not able to find it
    def get_array_element(*args)
      if ::Vertx::Util::unknown_type.accept?(args[0]) && args[1].class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:getArrayElement, [Java::java.lang.Object.java_class,Java::int.java_class]).call(::Vertx::Util::Utils.to_object(args[0]),args[1]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_array_element(#{args[0]},#{args[1]})"
      end
    end
    #  Instance of a JsonPointerIterator to query Vert.x Json structures
    def self.JSON_ITERATOR
      ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreJsonPointer::JsonPointerIterator.JSON_ITERATOR,::Vertx::JsonPointerIterator)
    end
  end
end
