require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.MultiMap
module Vertx
  #  This class represents a MultiMap of String keys to a List of String values.
  #  <p>
  #  It's useful in Vert.x to represent things in Vert.x like HTTP headers and HTTP parameters which allow
  #  multiple values for keys.
  class MultiMap
    # @private
    # @param j_del [::Vertx::MultiMap] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::MultiMap] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MultiMap
    end
    def @@j_api_type.wrap(obj)
      MultiMap.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCore::MultiMap.java_class
    end
    #  Adds a new value with the specified name and value.
    # @overload add(name,value)
    #   @param [String] name The name
    #   @param [String] value The value being added
    # @return [self]
    def add(*args)
      if args[0].class == String && args[1].class == String && !block_given?
        @j_del.java_method(:add, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add(#{args[0]},#{args[1]})"
      end
    end
    #  Check if there is a header with the specified <code>name</code> and <code>value</code>.
    # 
    #  If <code>caseInsensitive</code> is <code>true</code>, <code>value</code> is compared in a case-insensitive way.
    # @overload contains(name)
    #   @param [String] name The name to search for
    # @overload contains(name,value,caseInsensitive)
    #   @param [String] name the name to search for
    #   @param [String] value the value to search for
    #   @param [true,false] caseInsensitive 
    # @return [true,false] <code>true</code> if at least one entry is found
    def contains?(*args)
      if args[0].class == String && !block_given? && args[1] == nil && args[2] == nil
        return @j_del.java_method(:contains, [Java::java.lang.String.java_class]).call(args[0])
      elsif args[0].class == String && args[1].class == String && (args[2].class == TrueClass || args[2].class == FalseClass) && !block_given?
        return @j_del.java_method(:contains, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::boolean.java_class]).call(args[0],args[1],args[2])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling contains?(#{args[0]},#{args[1]},#{args[2]})"
      end
    end
    #  Sets a value under the specified name.
    #  <p>
    #  If there is an existing header with the same name, it is removed.
    # @overload set(name,value)
    #   @param [String] name The name
    #   @param [String] value The value
    # @return [self]
    def set(*args)
      if args[0].class == String && args[1].class == String && !block_given?
        @j_del.java_method(:set, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set(#{args[0]},#{args[1]})"
      end
    end
    #  Gets a immutable Set of all names
    # @overload names()
    # @return [Set<String>] A Set of all names
    def names
      if !block_given?
        return ::Vertx::Util::Utils.to_set(@j_del.java_method(:names, []).call()).map! { |elt| elt }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling names()"
      end
    end
    #  Returns the values with the specified name
    # @overload getAll(name)
    #   @param [String] name The name to search
    # @return [Array<String>] A immutable List of values which will be empty if no values are found
    def get_all(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:getAll, [Java::java.lang.String.java_class]).call(args[0]).to_a.map { |elt| elt }
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_all(#{args[0]})"
      end
    end
    #  Return the number of keys.
    # @overload size()
    # @return [Fixnum]
    def size
      if !block_given?
        return @j_del.java_method(:size, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling size()"
      end
    end
    #  Adds all the entries from another MultiMap to this one
    # @overload addAll(map)
    #   @param [::Vertx::MultiMap] map 
    # @return [self]
    def add_all(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:addAll, [Java::IoVertxCore::MultiMap.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling add_all(#{args[0]})"
      end
    end
    #  Returns the value of with the specified name.  If there are
    #  more than one values for the specified name, the first value is returned.
    # @overload get(name)
    #   @param [String] name The name of the header to search
    # @return [String] The first header value or <code>null</code> if there is no such entry
    def get(*args)
      if args[0].class == String && !block_given?
        return @j_del.java_method(:get, [Java::java.lang.String.java_class]).call(args[0])
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get(#{args[0]})"
      end
    end
    #  Removes all
    # @overload clear()
    # @return [self]
    def clear
      if !block_given?
        @j_del.java_method(:clear, []).call()
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling clear()"
      end
    end
    #  Return true if empty
    # @overload isEmpty()
    # @return [true,false]
    def empty?
      if !block_given?
        return @j_del.java_method(:isEmpty, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling empty?()"
      end
    end
    #  Cleans this instance.
    # @overload setAll(map)
    #   @param [::Vertx::MultiMap] map 
    # @return [self]
    def set_all(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:setAll, [Java::IoVertxCore::MultiMap.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling set_all(#{args[0]})"
      end
    end
    #  Create a multi-map implementation with case insensitive keys, for instance it can be used to hold some HTTP headers.
    # @overload caseInsensitiveMultiMap()
    # @return [::Vertx::MultiMap] the multi-map
    def self.case_insensitive_multi_map
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::MultiMap.java_method(:caseInsensitiveMultiMap, []).call(),::Vertx::MultiMap)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling case_insensitive_multi_map()"
      end
    end
    #  Removes the value with the given name
    # @overload remove(name)
    #   @param [String] name The name of the value to remove
    # @return [self]
    def remove(*args)
      if args[0].class == String && !block_given?
        @j_del.java_method(:remove, [Java::java.lang.String.java_class]).call(args[0])
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling remove(#{args[0]})"
      end
    end
  end
end
