require 'vertx/measured'
require 'vertx/promise'
require 'vertx/future'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.WorkerExecutor
module Vertx
  #  An executor for executing blocking code in Vert.x .<p>
  # 
  #  It provides the same <code>executeBlocking</code> operation than {::Vertx::Context} and
  #  {::Vertx::Vertx} but on a separate worker pool.<p>
  class WorkerExecutor
    include ::Vertx::Measured
    # @private
    # @param j_del [::Vertx::WorkerExecutor] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::WorkerExecutor] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == WorkerExecutor
    end
    def @@j_api_type.wrap(obj)
      WorkerExecutor.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCore::WorkerExecutor.java_class
    end
    #  Whether the metrics are enabled for this measured object
    # @overload isMetricsEnabled()
    # @return [true,false] <code>true</code> if metrics are enabled
    def metrics_enabled?
      if !block_given?
        return @j_del.java_method(:isMetricsEnabled, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling metrics_enabled?()"
      end
    end
    #  Safely execute some blocking code.
    #  <p>
    #  Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
    #  <p>
    #  When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
    #  (i.e. on the original event loop of the caller).
    #  <p>
    #  A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
    #  the handler should call the {::Vertx::Promise#complete} or {::Vertx::Promise#complete} method, or the {::Vertx::Promise#fail}
    #  method if it failed.
    #  <p>
    #  In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
    #  scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
    # @overload executeBlocking(blockingCodeHandler,resultHandler)
    #   @param [Proc] blockingCodeHandler 
    #   @yield 
    # @overload executeBlocking(blockingCodeHandler,ordered,resultHandler)
    #   @param [Proc] blockingCodeHandler handler representing the blocking code to run
    #   @param [true,false] ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
    #   @yield handler that will be called when the blocking code is complete
    # @return [void]
    def execute_blocking(*args)
      if args[0].class == Proc && true && args[1] == nil
        if (block_given?)
          return @j_del.java_method(:executeBlocking, [Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| args[0].call(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise, nil)) unless args[0] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.from_object(ar.result) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:executeBlocking, [Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| args[0].call(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise, nil)) unless args[0] == nil }),block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.from_object(ar.result) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      elsif args[0].class == Proc && (args[1].class == TrueClass || args[1].class == FalseClass) && true
        if (block_given?)
          return @j_del.java_method(:executeBlocking, [Java::IoVertxCore::Handler.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| args[0].call(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise, nil)) unless args[0] == nil }),args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.from_object(ar.result) : nil) } : promise)
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:executeBlocking, [Java::IoVertxCore::Handler.java_class,Java::boolean.java_class,Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| args[0].call(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise, nil)) unless args[0] == nil }),args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.from_object(ar.result) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling execute_blocking(#{args[0]},#{args[1]})"
      end
    end
    #  Close the executor.
    # @overload close()
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling close()"
      end
    end
  end
end
