require 'vertx/vertx'
require 'vertx-auth-oauth2/o_auth2_rbac'
require 'vertx/future'
require 'vertx-auth-oauth2/access_token'
require 'vertx-auth-common/auth_provider'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.oauth2.OAuth2Auth
module VertxAuthOauth2
  #  Factory interface for creating OAuth2 based {::VertxAuthCommon::AuthProvider} instances.
  class OAuth2Auth < ::VertxAuthCommon::AuthProvider
    # @private
    # @param j_del [::VertxAuthOauth2::OAuth2Auth] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthOauth2::OAuth2Auth] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == OAuth2Auth
    end
    def @@j_api_type.wrap(obj)
      OAuth2Auth.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthOauth2::OAuth2Auth.java_class
    end
    # @overload rbacHandler(rbac)
    #   @param [::VertxAuthOauth2::OAuth2RBAC] rbac 
    # @return [self]
    def rbac_handler(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:rbacHandler, [Java::IoVertxExtAuthOauth2::OAuth2RBAC.java_class]).call(args[0].j_del)
        return self
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling rbac_handler(#{args[0]})"
      end
    end
    #  Generate a redirect URL to the authN/Z backend. It only applies to auth_code flow.
    # @overload authorizeURL(params)
    #   @param [Hash{String => Object}] params 
    # @return [String]
    def authorize_url(*args)
      if args[0].class == Hash && !block_given?
        return @j_del.java_method(:authorizeURL, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling authorize_url(#{args[0]})"
      end
    end
    #  Loads a JWK Set from the remote provider.
    # 
    #  When calling this method several times, the loaded JWKs are updated in the underlying JWT object.
    # @overload loadJWK(handler)
    #   @yield 
    # @return [self]
    def load_jwk
      if true
        if (block_given?)
          @j_del.java_method(:loadJWK, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:loadJWK, [Java::IoVertxCore::Handler.java_class]).call(block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? nil : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future, nil)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling load_jwk()"
      end
    end
    #  Create a OAuth2 auth provider
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx the Vertx instance
    # @overload create(vertx,config)
    #   @param [::Vertx::Vertx] vertx the Vertx instance
    #   @param [Hash{String => Object}] config the config
    # @return [::VertxAuthOauth2::OAuth2Auth] the auth provider
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given? && args[1] == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthOauth2::OAuth2Auth.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(args[0].j_del),::VertxAuthOauth2::OAuth2Auth)
      elsif args[0].class.method_defined?(:j_del) && args[1].class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthOauth2::OAuth2Auth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtAuthOauth2::OAuth2ClientOptions.java_class]).call(args[0].j_del,Java::IoVertxExtAuthOauth2::OAuth2ClientOptions.new(::Vertx::Util::Utils.to_json_object(args[1]))),::VertxAuthOauth2::OAuth2Auth)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]},#{args[1]})"
      end
    end
    #  Decode a token to a {::VertxAuthOauth2::AccessToken} object. This is useful to handle bearer JWT tokens.
    # @overload decodeToken(token,handler)
    #   @param [String] token the access token (base64 string)
    #   @yield A handler to receive the event
    # @return [self]
    def decode_token(*args)
      if args[0].class == String && true
        if (block_given?)
          @j_del.java_method(:decodeToken, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::AccessToken) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:decodeToken, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::AccessToken) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxAuthOauth2::AccessToken.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling decode_token(#{args[0]})"
      end
    end
    #  Returns the configured flow type for the Oauth2 provider.
    # @overload getFlowType()
    # @return [:AUTH_CODE,:CLIENT,:PASSWORD,:AUTH_JWT] the flow type.
    def get_flow_type
      if !block_given?
        return @j_del.java_method(:getFlowType, []).call().name.intern
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling get_flow_type()"
      end
    end
    #  Query an OAuth 2.0 authorization server to determine the active state of an OAuth 2.0 token and to determine
    #  meta-information about this token.
    # @overload introspectToken(token,handler)
    #   @param [String] token the access token (base64 string)
    #   @yield A handler to receive the event
    # @overload introspectToken(token,tokenType,handler)
    #   @param [String] token the access token (base64 string)
    #   @param [String] tokenType hint to the token type e.g.: `access_token`
    #   @yield A handler to receive the event
    # @return [self]
    def introspect_token(*args)
      if args[0].class == String && true && args[1] == nil
        if (block_given?)
          @j_del.java_method(:introspectToken, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::AccessToken) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:introspectToken, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::AccessToken) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxAuthOauth2::AccessToken.j_api_type)
        end
      elsif args[0].class == String && args[1].class == String && true
        if (block_given?)
          @j_del.java_method(:introspectToken, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::AccessToken) : nil) } : promise)
          return self
        else
          promise = ::Vertx::Util::Utils.promise
          @j_del.java_method(:introspectToken, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(args[0],args[1],block_given? ? Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::AccessToken) : nil) } : promise)
          return ::Vertx::Util::Utils.safe_create(promise.future(),::Vertx::Future,::VertxAuthOauth2::AccessToken.j_api_type)
        end
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling introspect_token(#{args[0]},#{args[1]})"
      end
    end
  end
end
