require 'vertx-cassandra/cassandra_client'
require 'vertx-cassandra/mapper'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.cassandra.MappingManager
module VertxCassandra
  #  It is like , but adapted for Vert.x.
  class MappingManager
    # @private
    # @param j_del [::VertxCassandra::MappingManager] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxCassandra::MappingManager] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MappingManager
    end
    def @@j_api_type.wrap(obj)
      MappingManager.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCassandra::MappingManager.java_class
    end
    #  Create a {::VertxCassandra::MappingManager} from the given {::VertxCassandra::CassandraClient}.
    # @overload create(client)
    #   @param [::VertxCassandra::CassandraClient] client a Cassandra client instance
    # @return [::VertxCassandra::MappingManager]
    def self.create(*args)
      if args[0].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCassandra::MappingManager.java_method(:create, [Java::IoVertxCassandra::CassandraClient.java_class]).call(args[0].j_del),::VertxCassandra::MappingManager)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling create(#{args[0]})"
      end
    end
    #  Create a {::VertxCassandra::Mapper} that allows conversion of domain classes to and from query results.
    # @overload mapper(mappedClass)
    #   @param [Nil] mappedClass mapped class
    # @return [::VertxCassandra::Mapper]
    def mapper(*args)
      if args[0].class == Class && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:mapper, [Java::JavaLang::Class.java_class]).call(::Vertx::Util::Utils.j_class_of(args[0])),::VertxCassandra::Mapper, ::Vertx::Util::Utils.v_type_of(args[0]))
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling mapper(#{args[0]})"
      end
    end
  end
end
