require 'vertx/buffer'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.kafka.client.producer.KafkaHeader
module VertxKafkaClient
  #  Vert.x Kafka producer record header.
  class KafkaHeader
    # @private
    # @param j_del [::VertxKafkaClient::KafkaHeader] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxKafkaClient::KafkaHeader] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == KafkaHeader
    end
    def @@j_api_type.wrap(obj)
      KafkaHeader.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxKafkaClientProducer::KafkaHeader.java_class
    end
    # @overload header(key,value)
    #   @param [String] key 
    #   @param [::Vertx::Buffer] value 
    # @overload header(key,value)
    #   @param [String] key 
    #   @param [String] value 
    # @return [::VertxKafkaClient::KafkaHeader]
    def self.header(*args)
      if args[0].class == String && args[1].class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxKafkaClientProducer::KafkaHeader.java_method(:header, [Java::java.lang.String.java_class,Java::IoVertxCoreBuffer::Buffer.java_class]).call(args[0],args[1].j_del),::VertxKafkaClient::KafkaHeader)
      elsif args[0].class == String && args[1].class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxKafkaClientProducer::KafkaHeader.java_method(:header, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(args[0],args[1]),::VertxKafkaClient::KafkaHeader)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling header(#{args[0]},#{args[1]})"
      end
    end
    # @overload value()
    # @return [::Vertx::Buffer] the buffer value
    def value
      if !block_given?
        if @cached_value != nil
          return @cached_value
        end
        return @cached_value = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:value, []).call(),::Vertx::Buffer)
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling value()"
      end
    end
    # @overload key()
    # @return [String] the buffer key
    def key
      if !block_given?
        if @cached_key != nil
          return @cached_key
        end
        return @cached_key = @j_del.java_method(:key, []).call()
      end
      if defined?(super)
        super
      else
        raise ArgumentError, "Invalid arguments when calling key()"
      end
    end
  end
end
